"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLatestDesktopReleaseFileToFsV2 = exports.buildUrl = exports.isOpenGroupV2Request = exports.downloadFileFromFSv2 = exports.uploadFileToFsV2 = exports.useFileServerAPIV2Sending = exports.fileServerV2PubKey = exports.fileServerV2URL = void 0;
const util_worker_interface_1 = require("../../../webworker/workers/util_worker_interface");
const OpenGroupAPIV2_1 = require("../open_group_api/opengroupV2/OpenGroupAPIV2");
const OpenGroupAPIV2Parser_1 = require("../open_group_api/opengroupV2/OpenGroupAPIV2Parser");
exports.fileServerV2URL = 'http://fs1.rpcnode.stream';
exports.fileServerV2PubKey = 'f3024b309be838eff764c6804c417b667096d6c5301184f90fb66e9e4515444c';
const FILES_ENDPOINT = 'files';
const RELEASE_VERSION_ENDPOINT = 'bchat_version';
exports.useFileServerAPIV2Sending = true;
const uploadFileToFsV2 = async (fileContent) => {
    if (!fileContent || !fileContent.byteLength) {
        return null;
    }
    const queryParams = {
        file: await (0, util_worker_interface_1.callUtilsWorker)('arrayBufferToStringBase64', fileContent),
    };
    const request = {
        method: 'POST',
        endpoint: FILES_ENDPOINT,
        queryParams,
    };
    const result = await (0, OpenGroupAPIV2_1.sendApiV2Request)(request);
    console.log('FILES_ENDPOINT:result:', result);
    const statusCode = (0, OpenGroupAPIV2Parser_1.parseStatusCodeFromOnionRequest)(result);
    if (statusCode !== 200) {
        return null;
    }
    const fileId = result?.result?.result;
    if (!fileId) {
        return null;
    }
    const fileUrl = `${exports.fileServerV2URL}/${FILES_ENDPOINT}/${fileId}`;
    return {
        fileId: fileId,
        fileUrl,
    };
};
exports.uploadFileToFsV2 = uploadFileToFsV2;
const downloadFileFromFSv2 = async (fileIdOrCompleteUrl) => {
    let fileId = fileIdOrCompleteUrl;
    if (!fileIdOrCompleteUrl) {
        window?.log?.warn('Empty url to download for file v2');
        return null;
    }
    const newCompleteUrlPrefix = `${exports.fileServerV2URL}/${FILES_ENDPOINT}/`;
    if (fileIdOrCompleteUrl.startsWith(newCompleteUrlPrefix)) {
        fileId = fileId.substr(newCompleteUrlPrefix.length);
    }
    const request = {
        method: 'GET',
        endpoint: `${FILES_ENDPOINT}/${fileId}`,
    };
    const result = await (0, OpenGroupAPIV2_1.sendApiV2Request)(request);
    const statusCode = (0, OpenGroupAPIV2Parser_1.parseStatusCodeFromOnionRequest)(result);
    if (statusCode !== 200) {
        return null;
    }
    const base64Data = result?.result?.result;
    if (!base64Data) {
        return null;
    }
    return (0, util_worker_interface_1.callUtilsWorker)('fromBase64ToArrayBuffer', base64Data);
};
exports.downloadFileFromFSv2 = downloadFileFromFSv2;
function isOpenGroupV2Request(request) {
    return request.isAuthRequired !== undefined;
}
exports.isOpenGroupV2Request = isOpenGroupV2Request;
const buildUrl = (request) => {
    let rawURL;
    if (isOpenGroupV2Request(request)) {
        rawURL = `${request.server}/${request.endpoint}`;
    }
    else {
        rawURL = `${exports.fileServerV2URL}/${request.endpoint}`;
    }
    if (request.method === 'GET') {
        const entries = Object.entries(request.queryParams || {});
        if (entries.length) {
            const queryString = entries.map(([key, value]) => `${key}=${value}`).join('&');
            rawURL += `?${queryString}`;
        }
    }
    try {
        return new URL(`${rawURL}`);
    }
    catch (error) {
        return null;
    }
};
exports.buildUrl = buildUrl;
const getLatestDesktopReleaseFileToFsV2 = async () => {
    const queryParams = {
        platform: 'desktop',
    };
    const request = {
        method: 'GET',
        endpoint: RELEASE_VERSION_ENDPOINT,
        queryParams,
    };
    const result = await (0, OpenGroupAPIV2_1.sendApiV2Request)(request);
    console.log('RELEASE_VERSION_ENDPOINT:', result);
    const statusCode = (0, OpenGroupAPIV2Parser_1.parseStatusCodeFromOnionRequest)(result);
    if (statusCode !== 200) {
        return null;
    }
    const latestVersionWithV = result?.result?.result;
    if (!latestVersionWithV) {
        return null;
    }
    return latestVersionWithV;
};
exports.getLatestDesktopReleaseFileToFsV2 = getLatestDesktopReleaseFileToFsV2;
