"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseModerators = exports.parseRooms = exports.parseMemberCount = exports.parseStatusCodeFromOnionRequest = void 0;
const lodash_1 = __importDefault(require("lodash"));
const parseStatusCodeFromOnionRequest = (onionResult) => {
    if (!onionResult) {
        return undefined;
    }
    const statusCode = onionResult?.result?.status_code;
    if (statusCode) {
        return statusCode;
    }
    return undefined;
};
exports.parseStatusCodeFromOnionRequest = parseStatusCodeFromOnionRequest;
const parseMemberCount = (onionResult) => {
    if (!onionResult) {
        return undefined;
    }
    const memberCount = onionResult?.result?.member_count;
    if (memberCount) {
        return memberCount;
    }
    return undefined;
};
exports.parseMemberCount = parseMemberCount;
const parseRooms = (onionResult) => {
    if (!onionResult) {
        return undefined;
    }
    const rooms = onionResult?.result?.rooms;
    if (!rooms || !rooms.length) {
        window?.log?.warn('getAllRoomInfos failed invalid infos');
        return [];
    }
    return lodash_1.default.compact(rooms.map(room => {
        const { id, name, image_id: imageId } = room;
        if (!id || !name) {
            window?.log?.info('getAllRoomInfos: Got invalid room details, skipping');
            return null;
        }
        return { id, name, imageId };
    }));
};
exports.parseRooms = parseRooms;
const parseModerators = (onionResult) => {
    const moderatorsGot = onionResult?.result?.moderators;
    return moderatorsGot;
};
exports.parseModerators = parseModerators;
