"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageRequestResponse = void 0;
const protobuf_1 = require("../../../../protobuf");
const ContentMessage_1 = require("../ContentMessage");
class MessageRequestResponse extends ContentMessage_1.ContentMessage {
    isApproved;
    constructor(params) {
        super({
            timestamp: params.timestamp,
            isApproved: params.isApproved,
        });
        this.isApproved = params.isApproved;
    }
    contentProto() {
        return new protobuf_1.SignalService.Content({
            messageRequestResponse: this.messageRequestResponseProto(),
        });
    }
    messageRequestResponseProto() {
        return new protobuf_1.SignalService.MessageRequestResponse({
            isApproved: this.isApproved,
        });
    }
}
exports.MessageRequestResponse = MessageRequestResponse;
