"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VisibleMessage = void 0;
const bytebuffer_1 = __importDefault(require("bytebuffer"));
const __1 = require("..");
const protobuf_1 = require("../../../../protobuf");
class VisibleMessage extends __1.DataMessage {
    expireTimer;
    attachments;
    body;
    quote;
    profileKey;
    displayName;
    avatarPointer;
    preview;
    reaction;
    syncTarget;
    sharedContact;
    openGroupInvitation;
    payment;
    constructor(params) {
        super({ timestamp: params.timestamp, identifier: params.identifier });
        this.attachments = params.attachments;
        this.body = params.body;
        this.quote = params.quote;
        this.expireTimer = params.expireTimer;
        if (params.lokiProfile && params.lokiProfile.profileKey) {
            if (params.lokiProfile.profileKey instanceof Uint8Array ||
                params.lokiProfile.profileKey instanceof bytebuffer_1.default) {
                this.profileKey = new Uint8Array(params.lokiProfile.profileKey);
            }
            else {
                this.profileKey = new Uint8Array(bytebuffer_1.default.wrap(params.lokiProfile.profileKey).toArrayBuffer());
            }
        }
        this.displayName = params.lokiProfile && params.lokiProfile.displayName;
        this.avatarPointer = params.lokiProfile && params.lokiProfile.avatarPointer;
        this.preview = params.preview;
        this.syncTarget = params.syncTarget;
        this.reaction = params.reaction;
        this.sharedContact = params.sharedContact;
        this.openGroupInvitation = params.openGroupInvitation;
        this.payment = params.payment;
    }
    dataProto() {
        const dataMessage = new protobuf_1.SignalService.DataMessage();
        if (this.body) {
            dataMessage.body = this.body;
        }
        dataMessage.attachments = this.attachments || [];
        if (this.expireTimer) {
            dataMessage.expireTimer = this.expireTimer;
        }
        if (this.preview) {
            dataMessage.preview = this.preview;
        }
        if (this.syncTarget) {
            dataMessage.syncTarget = this.syncTarget;
        }
        if (this.avatarPointer || this.displayName) {
            const profile = new protobuf_1.SignalService.DataMessage.LokiProfile();
            if (this.avatarPointer) {
                profile.profilePicture = this.avatarPointer;
            }
            if (this.displayName) {
                profile.displayName = this.displayName;
            }
            dataMessage.profile = profile;
        }
        if (this.profileKey && this.profileKey.length) {
            dataMessage.profileKey = this.profileKey;
        }
        if (this.quote) {
            dataMessage.quote = new protobuf_1.SignalService.DataMessage.Quote();
            dataMessage.quote.id = this.quote.id;
            dataMessage.quote.author = this.quote.author;
            dataMessage.quote.text = this.quote.text;
            if (this.quote.attachments) {
                dataMessage.quote.attachments = this.quote.attachments.map(attachment => {
                    const quotedAttachment = new protobuf_1.SignalService.DataMessage.Quote.QuotedAttachment();
                    if (attachment.contentType) {
                        quotedAttachment.contentType = attachment.contentType;
                    }
                    if (attachment.fileName) {
                        quotedAttachment.fileName = attachment.fileName;
                    }
                    if (attachment.thumbnail && attachment.thumbnail.id) {
                        quotedAttachment.thumbnail = attachment.thumbnail;
                    }
                    return quotedAttachment;
                });
            }
        }
        if (Array.isArray(this.preview)) {
            dataMessage.preview = this.preview.map(preview => {
                const item = new protobuf_1.SignalService.DataMessage.Preview();
                if (preview.title) {
                    item.title = preview.title;
                }
                if (preview.url) {
                    item.url = preview.url;
                }
                item.image = preview.image || null;
                return item;
            });
        }
        if (this.reaction) {
            dataMessage.reaction = this.reaction;
        }
        if (this.openGroupInvitation) {
            dataMessage.openGroupInvitation = new protobuf_1.SignalService.DataMessage.OpenGroupInvitation();
            dataMessage.openGroupInvitation.name = this.openGroupInvitation.name;
            dataMessage.openGroupInvitation.url = this.openGroupInvitation.url;
        }
        if (this.payment) {
            dataMessage.payment = new protobuf_1.SignalService.DataMessage.Payment();
            dataMessage.payment.amount = this.payment.amount;
            dataMessage.payment.txnId = this.payment.txnId;
        }
        if (this.sharedContact) {
            dataMessage.sharedContact = new protobuf_1.SignalService.DataMessage.SharedContact();
            dataMessage.sharedContact.address = this.sharedContact.address;
            dataMessage.sharedContact.name = this.sharedContact.name;
        }
        dataMessage.timestamp = this.timestamp;
        return dataMessage;
    }
    isEqual(comparator) {
        return this.identifier === comparator.identifier && this.timestamp === comparator.timestamp;
    }
}
exports.VisibleMessage = VisibleMessage;
