"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uploadQuoteThumbnailsV2 = exports.uploadLinkPreviewsV2 = exports.uploadAttachmentsV2 = exports.uploadV2 = void 0;
const OpenGroupAPIV2_1 = require("../apis/open_group_api/opengroupV2/OpenGroupAPIV2");
const BufferPadding_1 = require("../crypto/BufferPadding");
const lodash_1 = __importDefault(require("lodash"));
const _1 = require(".");
async function uploadV2(params) {
    const { attachment, openGroup } = params;
    if (typeof attachment !== 'object' || attachment == null) {
        throw new Error('Invalid attachment passed.');
    }
    if (!(attachment.data instanceof ArrayBuffer)) {
        throw new TypeError(`attachment.data must be an ArrayBuffer but got: ${typeof attachment.data}`);
    }
    const pointer = {
        contentType: attachment.contentType || undefined,
        size: attachment.size,
        fileName: attachment.fileName,
        flags: attachment.flags,
        caption: attachment.caption,
    };
    const paddedAttachment = !openGroup
        ? (0, BufferPadding_1.addAttachmentPadding)(attachment.data)
        : attachment.data;
    const fileDetails = await (0, OpenGroupAPIV2_1.uploadFileOpenGroupV2)(new Uint8Array(paddedAttachment), openGroup);
    if (!fileDetails) {
        throw new Error(`upload to fileopengroupv2 of ${attachment.fileName} failed`);
    }
    return {
        ...pointer,
        id: fileDetails.fileId,
        url: fileDetails.fileUrl,
    };
}
exports.uploadV2 = uploadV2;
async function uploadAttachmentsV2(attachments, openGroup) {
    const promises = (attachments || []).map(async (attachment) => _1.AttachmentsV2Utils.uploadV2({
        attachment,
        openGroup,
    }));
    return Promise.all(promises);
}
exports.uploadAttachmentsV2 = uploadAttachmentsV2;
async function uploadLinkPreviewsV2(previews, openGroup) {
    const promises = (previews || []).map(async (preview) => {
        if (!preview.image) {
            window.log.warn('tried to upload file to opengroupv2 without image.. skipping');
            return undefined;
        }
        const image = await _1.AttachmentsV2Utils.uploadV2({
            attachment: preview.image,
            openGroup,
        });
        return {
            ...preview,
            image,
            url: preview.url || image.url,
            id: image.id,
        };
    });
    return lodash_1.default.compact(await Promise.all(promises));
}
exports.uploadLinkPreviewsV2 = uploadLinkPreviewsV2;
async function uploadQuoteThumbnailsV2(openGroup, quote) {
    if (!quote) {
        return undefined;
    }
    const promises = (quote.attachments ?? []).map(async (attachment) => {
        let thumbnail;
        if (attachment.thumbnail) {
            thumbnail = (await _1.AttachmentsV2Utils.uploadV2({
                attachment: attachment.thumbnail,
                openGroup,
            }));
        }
        return {
            ...attachment,
            thumbnail,
        };
    });
    const attachments = await Promise.all(promises);
    return {
        ...quote,
        attachments,
    };
}
exports.uploadQuoteThumbnailsV2 = uploadQuoteThumbnailsV2;
