"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatMainPanel = exports.getconverstation = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const useAppFocused_1 = require("../hooks/useAppFocused");
const section_1 = require("../state/selectors/section");
const BchatConversation_1 = require("../state/smart/BchatConversation");
const BchatSettings_1 = require("./settings/BchatSettings");
const User_1 = require("../bchat/utils/User");
const data_1 = require("../data/data");
const modalDialog_1 = require("../state/ducks/modalDialog");
const FilteredSettingsView = BchatSettings_1.BchatSettingsView;
async function getconverstation() {
    let userDetails = await (0, data_1.getConversationById)((0, User_1.getOurPubKeyStrFromCache)());
    let data = userDetails?.attributes;
    if (data?.walletCreatedDaemonHeight === null) {
        window.inboxStore?.dispatch((0, modalDialog_1.updateBchatUpgradeInstructionModal)({}));
    }
}
exports.getconverstation = getconverstation;
const BchatMainPanel = () => {
    const focusedSettingsSection = (0, react_redux_1.useSelector)(section_1.getFocusedSettingsSection);
    const isSettingsView = focusedSettingsSection !== undefined;
    (0, useAppFocused_1.useAppIsFocused)();
    if (isSettingsView) {
        return react_1.default.createElement(FilteredSettingsView, { category: focusedSettingsSection });
    }
    return (react_1.default.createElement("div", { className: "bchat-conversation" },
        react_1.default.createElement(BchatConversation_1.SmartBchatConversation, null)));
};
exports.BchatMainPanel = BchatMainPanel;
