"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatSearchInput = void 0;
const lodash_1 = require("lodash");
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const search_1 = require("../state/ducks/search");
const conversations_1 = require("../state/selectors/conversations");
const cleanSearchTerm_1 = require("../util/cleanSearchTerm");
const icon_1 = require("./icon");
const doTheSearch = (dispatch, cleanedTerm) => {
    dispatch((0, search_1.search)(cleanedTerm));
};
const debouncedSearch = (0, lodash_1.debounce)(doTheSearch, 50);
function updateSearch(dispatch, searchTerm) {
    if (!searchTerm) {
        dispatch((0, search_1.clearSearch)());
        return;
    }
    dispatch((0, search_1.updateSearchTerm)(searchTerm));
    if (searchTerm.length < 2) {
        return;
    }
    const cleanedTerm = (0, cleanSearchTerm_1.cleanSearchTerm)(searchTerm);
    if (!cleanedTerm) {
        return;
    }
    debouncedSearch(dispatch, searchTerm);
}
const BchatSearchInput = () => {
    const [currentSearchTerm, setCurrentSearchTerm] = (0, react_1.useState)('');
    const dispatch = (0, react_redux_1.useDispatch)();
    const convoCount = (0, react_redux_1.useSelector)(conversations_1.getConversationsCount);
    if (convoCount < 1) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "bchat-search-input" },
        react_1.default.createElement("div", { className: 'search' },
            react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: "search" })),
        react_1.default.createElement("input", { value: currentSearchTerm, onChange: e => {
                const inputValue = e.target.value;
                setCurrentSearchTerm(inputValue);
                updateSearch(dispatch, inputValue);
            }, placeholder: window.i18n('searchFor...'), maxLength: 26 }),
        !!currentSearchTerm.length && (react_1.default.createElement(icon_1.BchatIconButton, { iconSize: 24, iconType: "exit", onClick: () => {
                setCurrentSearchTerm('');
                dispatch((0, search_1.clearSearch)());
            } }))));
};
exports.BchatSearchInput = BchatSearchInput;
