"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatWrapperModal = exports.Loader = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const icon_1 = require("./icon");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const styled_components_1 = __importDefault(require("styled-components"));
const BchatSpinner_1 = require("./basic/BchatSpinner");
const BchatButton_1 = require("./basic/BchatButton");
exports.Loader = styled_components_1.default.div `
  position: absolute;
  top: 0;
  left: 0;
  background-color: var(--color-loader-bg);
  display: flex;
  justify-content: center;
  width: 100%;
  height: 100%;
  align-items: center;
  z-index: 101;
`;
const BchatWrapperModal = (props) => {
    const { title, showHeader = true, showExitIcon, headerIconButtons, headerReverse, additionalClassName, isloading, okButton, cancelButton, iconShow = false, customIcon, buttonSizeLg = false, } = props;
    (0, useKey_1.default)('Esc', () => {
        props.onClose?.();
    }, undefined, [props.onClose]);
    (0, useKey_1.default)('Escape', () => {
        props.onClose?.();
    }, undefined, [props.onClose]);
    const modalRef = (0, react_1.useRef)(null);
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-dialog modal', additionalClassName ? additionalClassName : null) },
        react_1.default.createElement("div", { className: "bchat-confirm-wrapper" },
            react_1.default.createElement("div", { ref: modalRef, className: "bchat-modal" },
                react_1.default.createElement("div", { className: "model-layer" },
                    iconShow && react_1.default.createElement("div", { className: "mediaPermission" }, customIcon),
                    react_1.default.createElement("div", null,
                        showHeader ? (react_1.default.createElement("div", { style: { display: 'flex', flexDirection: 'row', justifyContent: 'space-between' } },
                            react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-modal__header', headerReverse && 'reverse') },
                                react_1.default.createElement("div", { className: "bchat-modal__header__title" }, title),
                                react_1.default.createElement("div", { className: (0, classnames_1.default)(headerIconButtons && "bchat-modal__header__icons") }, headerIconButtons
                                    ? headerIconButtons.map((iconItem) => {
                                        return (react_1.default.createElement(icon_1.BchatIconButton, { key: iconItem.iconType, iconType: iconItem.iconType, iconSize: 'large', iconRotation: iconItem.iconRotation, onClick: iconItem.onClick }));
                                    })
                                    : null)),
                            react_1.default.createElement("div", { className: "bchat-modal__header__iconHeader" }, showExitIcon && (react_1.default.createElement("div", { className: "bchat-modal__header__close" },
                                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "exit", iconSize: 25, onClick: props.onClose, dataTestId: "modal-close-button" })))))) : null,
                        react_1.default.createElement("div", { className: "bchat-modal__body", style: { position: 'relative' } },
                            react_1.default.createElement("div", { className: "bchat-modal__centered" }, props.children)))),
                react_1.default.createElement("div", { className: "bchat-modal-footer" },
                    cancelButton?.status && (react_1.default.createElement(BchatButton_1.BchatButton, { text: cancelButton?.text, buttonType: cancelButton?.buttonType ? cancelButton.buttonType : BchatButton_1.BchatButtonType.Brand, buttonColor: cancelButton?.color ? cancelButton.color : BchatButton_1.BchatButtonColor.Secondary, onClick: cancelButton.onClickCancelHandler, iconSize: cancelButton?.iconSize ? cancelButton.iconSize : 10, iconType: cancelButton?.iconType, dataTestId: "Bchat-confirm-cancel-button", style: { marginRight: '12px', minWidth: iconShow || buttonSizeLg ? '235px' : '200px' } })),
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: okButton?.text ? okButton.text : window.i18n('ok'), buttonType: okButton?.buttonType ? okButton.buttonType : BchatButton_1.BchatButtonType.Brand, buttonColor: okButton?.color ? okButton.color : BchatButton_1.BchatButtonColor.Secondary, disabled: okButton?.disabled, iconSize: okButton?.iconSize ? okButton.iconSize : 10, iconType: okButton?.iconType, onClick: okButton?.onClickOkHandler, dataTestId: okButton?.dataTestId ? okButton.dataTestId : 'Bchat-confirm-ok-button', style: { minWidth: iconShow || buttonSizeLg ? '235px' : '200px' } })),
                isloading && (react_1.default.createElement("div", null,
                    react_1.default.createElement(exports.Loader, null,
                        react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: true }))))))));
};
exports.BchatWrapperModal = BchatWrapperModal;
