"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CaptionEditor = void 0;
const react_1 = __importDefault(require("react"));
const GoogleChrome = __importStar(require("../util/GoogleChrome"));
const auto_bind_1 = __importDefault(require("auto-bind"));
const BchatButton_1 = require("./basic/BchatButton");
const BchatInput_1 = require("./basic/BchatInput");
class CaptionEditor extends react_1.default.Component {
    inputRef;
    constructor(props) {
        super(props);
        const { caption } = props;
        this.state = {
            caption: caption || '',
        };
        (0, auto_bind_1.default)(this);
        this.inputRef = react_1.default.createRef();
    }
    onSave() {
        const { onSave } = this.props;
        const { caption } = this.state;
        onSave(caption);
    }
    onChange(value) {
        this.setState({
            caption: value,
        });
    }
    renderObject() {
        const { url, onClose, attachment } = this.props;
        const { contentType } = attachment || { contentType: null };
        const isImageTypeSupported = GoogleChrome.isImageTypeSupported(contentType);
        if (isImageTypeSupported) {
            return (react_1.default.createElement("img", { className: "module-caption-editor__image", alt: window.i18n('imageAttachmentAlt'), src: url, onClick: onClose }));
        }
        const isVideoTypeSupported = GoogleChrome.isVideoTypeSupported(contentType);
        if (isVideoTypeSupported) {
            return (react_1.default.createElement("video", { className: "module-caption-editor__video", controls: true },
                react_1.default.createElement("source", { src: url })));
        }
        return react_1.default.createElement("div", { className: "module-caption-editor__placeholder" });
    }
    render() {
        const { onClose } = this.props;
        const { caption } = this.state;
        return (react_1.default.createElement("div", { role: "dialog", className: "module-caption-editor" },
            react_1.default.createElement("div", { role: "button", onClick: onClose, className: "module-caption-editor__close-button" }),
            react_1.default.createElement("div", { className: "module-caption-editor__media-container" }, this.renderObject()),
            react_1.default.createElement("div", { className: "module-caption-editor__bottom-bar" },
                react_1.default.createElement("div", { className: "module-caption-editor__input-container" },
                    react_1.default.createElement(BchatInput_1.BchatInput, { type: "text", autoFocus: true, maxLength: 200, ref: this.inputRef, placeholder: window.i18n('addACaption'), enableShowHide: false, onValueChanged: this.onChange, onEnterPressed: this.onSave, value: caption }),
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('save'), onClick: this.onSave, buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Green, disabled: !caption })))));
    }
}
exports.CaptionEditor = CaptionEditor;
