"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplitViewContainer = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const call_1 = require("../state/selectors/call");
const SlyledSplitView = styled_components_1.default.div `
  height: 100%;
  display: flex;
  flex-direction: column;
`;
const Divider = styled_components_1.default.div `
  width: 100%;
  cursor: row-resize;
  height: 5px;
  background-color: var(--color-conversation-item-selected);
  margin-top: 2px;
`;
const DividerHandle = styled_components_1.default.div `
  width: 10%;
  height: 5px;
  cursor: row-resize;
  background-color: var(--color-text);
  flex-shrink: 0;
  position: relative;
  left: 50%;
  transform: translateX(-50%);
`;
const StyledTop = styled_components_1.default.div `
  display: flex;
  flex-direction: column;
  flex-grow: 1;
`;
const TopSplitViewPanel = ({ children, topHeight, setTopHeight, }) => {
    const topRef = (0, react_1.useRef)(null);
    react_1.default.useEffect(() => {
        if (topRef.current) {
            if (!topHeight) {
                setTopHeight(Math.max(MIN_HEIGHT_TOP, topRef.current?.clientHeight / 2));
                return;
            }
            topRef.current.style.height = `${topHeight}px`;
            topRef.current.style.minHeight = `${topHeight}px`;
        }
    }, [topRef, topHeight, setTopHeight]);
    return react_1.default.createElement(StyledTop, { ref: topRef }, children);
};
const MIN_HEIGHT_TOP = 200;
const MIN_HEIGHT_BOTTOM = 0;
const SplitViewContainer = ({ disableTop, top, bottom, }) => {
    const [topHeight, setTopHeight] = (0, react_1.useState)(undefined);
    const [separatorYPosition, setSeparatorYPosition] = (0, react_1.useState)(undefined);
    const [dragging, setDragging] = (0, react_1.useState)(false);
    const splitPaneRef = (0, react_1.useRef)(null);
    const dividerRef = (0, react_1.useRef)(null);
    const isInFullScreen = (0, react_redux_1.useSelector)(call_1.getCallIsInFullScreen);
    function onMouseDown(e) {
        setSeparatorYPosition(e.clientY);
        setDragging(true);
    }
    function onWindowResize() {
        if ((dividerRef?.current?.offsetTop || 0) + 200 > window.innerHeight) {
            const clientY = Math.max(MIN_HEIGHT_TOP + 200, window.innerHeight / 2);
            onMouseMove({ clientY }, true);
        }
    }
    function onMouseUp() {
        setDragging(false);
    }
    function onMouseMove(e, overrideIsDragging = false) {
        if ((dragging || overrideIsDragging) && topHeight && separatorYPosition) {
            const newTopHeight = topHeight + e.clientY - separatorYPosition;
            setSeparatorYPosition(e.clientY);
            if (newTopHeight < MIN_HEIGHT_TOP) {
                setTopHeight(MIN_HEIGHT_TOP);
                return;
            }
            if (splitPaneRef.current) {
                const splitPaneHeight = splitPaneRef.current.clientHeight;
                if (newTopHeight > splitPaneHeight - MIN_HEIGHT_BOTTOM) {
                    setTopHeight(splitPaneHeight - MIN_HEIGHT_BOTTOM);
                    return;
                }
            }
            setTopHeight(newTopHeight);
        }
    }
    (0, react_1.useEffect)(() => {
        document.addEventListener('mousemove', onMouseMove);
        document.addEventListener('mouseup', onMouseUp);
        window.addEventListener('resize', onWindowResize);
        return () => {
            document.removeEventListener('mousemove', onMouseMove);
            document.removeEventListener('mouseup', onMouseUp);
            window.removeEventListener('resize', onWindowResize);
        };
    });
    return (react_1.default.createElement(SlyledSplitView, { ref: splitPaneRef },
        !disableTop && !isInFullScreen ? (react_1.default.createElement(TopSplitViewPanel, { topHeight: topHeight, setTopHeight: setTopHeight },
            top,
            react_1.default.createElement(Divider, { ref: dividerRef, onMouseDown: onMouseDown },
                react_1.default.createElement(DividerHandle, null)))) : null,
        bottom));
};
exports.SplitViewContainer = SplitViewContainer;
