"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Avatar = exports.CrownIcon = exports.Identicon = exports.AvatarSize = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const useEncryptedFileFetch_1 = require("../../hooks/useEncryptedFileFetch");
const lodash_1 = require("lodash");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const AvatarPlaceHolder_1 = require("./AvatarPlaceHolder/AvatarPlaceHolder");
const ClosedGroupAvatar_1 = require("./AvatarPlaceHolder/ClosedGroupAvatar");
const useDisableDrag_1 = require("../../hooks/useDisableDrag");
const styled_components_1 = __importDefault(require("styled-components"));
const VerifyPadgeIcon_1 = __importDefault(require("../icon/VerifyPadgeIcon"));
var AvatarSize;
(function (AvatarSize) {
    AvatarSize[AvatarSize["XS"] = 28] = "XS";
    AvatarSize[AvatarSize["S"] = 36] = "S";
    AvatarSize[AvatarSize["M"] = 48] = "M";
    AvatarSize[AvatarSize["L"] = 60] = "L";
    AvatarSize[AvatarSize["XL"] = 80] = "XL";
    AvatarSize[AvatarSize["XXL"] = 130] = "XXL";
    AvatarSize[AvatarSize["XXXL"] = 200] = "XXXL";
    AvatarSize[AvatarSize["HUGE"] = 300] = "HUGE";
})(AvatarSize = exports.AvatarSize || (exports.AvatarSize = {}));
const Identicon = (props) => {
    const { size, forcedName, pubkey, isGroup } = props;
    const displayName = (0, useParamSelector_1.useConversationUsername)(pubkey);
    const userName = forcedName || displayName || '0';
    return react_1.default.createElement(AvatarPlaceHolder_1.AvatarPlaceHolder, { diameter: size, name: userName, pubkey: pubkey, isGroup: isGroup });
};
exports.Identicon = Identicon;
const CrownWrapper = styled_components_1.default.div `
  // height: 15px;
  // width: 15px;
  height: 18px;
  width: 18px;
  position: absolute;
  top: -12px;
  left: 15px;
`;
const CrownIcon = () => {
    return (react_1.default.createElement(CrownWrapper, null,
        react_1.default.createElement("img", { src: "images/bchat/Crown.svg", width: '100%', height: '100%' })));
};
exports.CrownIcon = CrownIcon;
const NoImage = (props) => {
    const { forcedName, size, pubkey, isClosedGroup } = props;
    if (pubkey && isClosedGroup) {
        return (react_1.default.createElement(ClosedGroupAvatar_1.ClosedGroupAvatar, { size: size, closedGroupId: pubkey, onAvatarClick: props.onAvatarClick }));
    }
    return react_1.default.createElement(exports.Identicon, { size: size, forcedName: forcedName, pubkey: pubkey });
};
const AvatarImage = (props) => {
    const { avatarPath, base64Data, name, imageBroken, datatestId, handleImageError } = props;
    const disableDrag = (0, useDisableDrag_1.useDisableDrag)();
    if ((!avatarPath && !base64Data) || imageBroken) {
        return null;
    }
    const dataToDisplay = base64Data ? `data:image/jpeg;base64,${base64Data}` : avatarPath;
    return (react_1.default.createElement("img", { onError: handleImageError, onDragStart: disableDrag, alt: window.i18n('contactAvatarAlt', [name || 'avatar']), src: dataToDisplay, "data-testid": datatestId }));
};
const AvatarInner = (props) => {
    const { base64Data, size, pubkey, forcedAvatarPath, forcedName, dataTestId, isBnsHolder } = props;
    const [imageBroken, setImageBroken] = (0, react_1.useState)(false);
    const isClosedGroupAvatar = (0, useParamSelector_1.useIsClosedGroup)(pubkey);
    const avatarPath = (0, useParamSelector_1.useAvatarPath)(pubkey);
    const name = (0, useParamSelector_1.useConversationUsername)(pubkey);
    const { urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(forcedAvatarPath || avatarPath || '', '', true);
    const handleImageError = () => {
        window.log.warn('Avatar: Image failed to load; failing over to placeholder', urlToLoad, forcedAvatarPath || avatarPath);
        setImageBroken(true);
    };
    const hasImage = (base64Data || urlToLoad) && !imageBroken && !isClosedGroupAvatar;
    const isClickable = !!props.onAvatarClick;
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)(isBnsHolder && 'module-avatar-verify-wrapper', 'bns-verify-wrapper') },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-avatar', `module-avatar--${size}`, hasImage ? 'module-avatar--with-image' : 'module-avatar--no-image', isClickable && 'module-avatar-clickable'), onMouseDown: e => {
                if (props.onAvatarClick) {
                    e.stopPropagation();
                    e.preventDefault();
                    props.onAvatarClick?.();
                }
            }, role: "button", "data-testid": dataTestId },
            hasImage ? (react_1.default.createElement(AvatarImage, { avatarPath: urlToLoad, base64Data: base64Data, imageBroken: imageBroken, name: forcedName || name, handleImageError: handleImageError, datatestId: dataTestId ? `img-${dataTestId}` : undefined })) : (react_1.default.createElement(NoImage, { ...props, isClosedGroup: isClosedGroupAvatar })),
            !!isBnsHolder && (react_1.default.createElement("span", { className: "module-avatar-verify-wrapper-verify-tag", style: { bottom: -7, right: -7 } },
                react_1.default.createElement(VerifyPadgeIcon_1.default, null))))));
};
exports.Avatar = react_1.default.memo(AvatarInner, lodash_1.isEqual);
