"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvatarPlaceHolder = exports.avatarPlaceholderColors = exports.cachedHashes = void 0;
const react_1 = __importStar(require("react"));
const sha512FromPubkey = async (pubkey) => {
    const buf = await crypto.subtle.digest('SHA-512', new TextEncoder().encode(pubkey));
    return Array.prototype.map
        .call(new Uint8Array(buf), (x) => ('00' + x.toString(16)).slice(-2))
        .join('');
};
exports.cachedHashes = new Map();
exports.avatarPlaceholderColors = [
    {
        bgColor: '#9A58CD',
        bodyColor: '#623882',
    },
    {
        bgColor: '#A9D1FD',
        bodyColor: '#3C7ABD',
    },
    {
        bgColor: '#FFE5A6',
        bodyColor: '#BA8555',
    },
    {
        bgColor: '#CE413B',
        bodyColor: '#802A2A',
    },
];
const avatarBorderColor = '#00000059';
function useHashBasedOnPubkey(pubkey) {
    const [hash, setHash] = (0, react_1.useState)(undefined);
    const [loading, setIsLoading] = (0, react_1.useState)(true);
    (0, react_1.useEffect)(() => {
        const cachedHash = exports.cachedHashes.get(pubkey);
        if (cachedHash) {
            setHash(cachedHash);
            setIsLoading(false);
            return;
        }
        setIsLoading(true);
        let isInProgress = true;
        if (!pubkey) {
            if (isInProgress) {
                setIsLoading(false);
                setHash(undefined);
            }
            return;
        }
        void sha512FromPubkey(pubkey).then(sha => {
            if (isInProgress) {
                setIsLoading(false);
                if (sha) {
                    const hashed = parseInt(sha.substring(0, 12), 16) || 0;
                    setHash(hashed);
                    exports.cachedHashes.set(pubkey, hashed);
                    return;
                }
                setHash(undefined);
            }
        });
        return () => {
            isInProgress = false;
        };
    }, [pubkey]);
    return { loading, hash };
}
const AvatarPlaceHolder = (props) => {
    const { pubkey, diameter, isGroup, } = props;
    const { hash, loading } = useHashBasedOnPubkey(pubkey);
    const viewBox = `0 0 ${diameter} ${diameter}`;
    if (loading || !hash) {
        return (react_1.default.createElement("svg", { viewBox: viewBox },
            react_1.default.createElement("g", { id: "UrTavla" },
                react_1.default.createElement("rect", { rx: 10, ry: 10, fill: "#d2d2d3", width: diameter, height: diameter, stroke: avatarBorderColor, strokeWidth: "1" }))));
    }
    const bgColorIndex = hash % exports.avatarPlaceholderColors.length;
    const avatarColors = exports.avatarPlaceholderColors[bgColorIndex];
    if (isGroup) {
        return (react_1.default.createElement("div", { style: {
                width: { diameter } + 'px',
                height: { diameter } + 'px',
                borderRadius: '12px',
                overflow: 'hidden',
            } },
            react_1.default.createElement("svg", { width: "100%", height: "100%", viewBox: "0 0 60 60", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                react_1.default.createElement("rect", { width: "60", height: "60", rx: "16", fill: avatarColors.bgColor }),
                react_1.default.createElement("path", { d: "M30.3627 32.9066C31.7068 32.9066 32.7996 34.0007 32.7996 35.3448V36.2762C32.7993 40.6943 27.7203 42.7073 23.0001 42.7075C20.5203 42.7075 18.1942 42.1779 16.4502 41.2145C14.3543 40.0586 13.1994 38.305 13.1992 36.2762V35.3448C13.1992 34.0008 14.2922 32.9068 15.6362 32.9066H30.3627ZM44.3623 32.9066C45.7059 32.9069 46.7988 33.9999 46.7992 35.3436V36.2762C46.7989 40.6944 41.7187 42.7075 36.9984 42.7075C35.2642 42.7074 33.6058 42.4469 32.1686 41.9616C33.7611 40.6279 34.902 38.7448 34.9022 36.2762V35.3436C34.902 34.4469 34.6403 33.6108 34.1904 32.9066H44.3623ZM23.5377 19.0547C26.3924 19.0547 28.7069 21.3704 28.7069 24.2252C28.7066 27.0796 26.3922 29.3944 23.5377 29.3944C20.6831 29.3944 18.3688 27.0796 18.3684 24.2252C18.3684 21.3704 20.6829 19.0547 23.5377 19.0547ZM37.7531 19.0547C40.6078 19.0547 42.9223 21.3704 42.9223 24.2252C42.922 27.0796 40.6076 29.3944 37.7531 29.3944C34.8985 29.3944 32.5842 27.0796 32.5838 24.2252C32.5838 21.3704 34.8983 19.0547 37.7531 19.0547Z", fill: avatarColors.bodyColor }))));
    }
    return (react_1.default.createElement("div", { style: {
            width: { diameter } + 'px',
            height: { diameter } + 'px',
            borderRadius: '12px',
            overflow: 'hidden',
        } },
        react_1.default.createElement("svg", { width: "100%", height: "100%", viewBox: "0 0 60 60", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react_1.default.createElement("rect", { width: "60", height: "60", rx: "0", fill: avatarColors.bgColor }),
            react_1.default.createElement("path", { d: "M40.5182 33.5H19.4818C17.5616 33.5 16 35.0616 16 36.9818V38.3125C16 41.2109 17.6497 43.7159 20.6439 45.3672C23.1352 46.7435 26.4575 47.5 30 47.5C36.7433 47.5 44 44.6244 44 38.3125V36.9818C44 35.0616 42.4384 33.5 40.5182 33.5Z", fill: avatarColors.bodyColor }),
            react_1.default.createElement("path", { d: "M21.25 21.75C21.25 16.9178 25.1678 13 30 13C34.8322 13 38.75 16.9178 38.75 21.75C38.75 26.5823 34.8322 30.5 30 30.5C25.1678 30.5 21.25 26.5823 21.25 21.75Z", fill: "url(#paint0_radial_228_1958)" }),
            react_1.default.createElement("defs", null,
                react_1.default.createElement("radialGradient", { id: "paint0_radial_228_1958", cx: "0", cy: "0", r: "1", gradientUnits: "userSpaceOnUse", gradientTransform: "translate(30 21.75) rotate(90) scale(8.75 8.75)" },
                    react_1.default.createElement("stop", { stopColor: "#FFBF91" }),
                    react_1.default.createElement("stop", { offset: "0.625", stopColor: "#FFB077" }),
                    react_1.default.createElement("stop", { offset: "1", stopColor: "#DD9561" }))))));
};
exports.AvatarPlaceHolder = AvatarPlaceHolder;
