"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatButton = exports.BchatButtonColor = exports.BchatButtonType = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const icon_1 = require("../icon");
var BchatButtonType;
(function (BchatButtonType) {
    BchatButtonType["Brand"] = "brand";
    BchatButtonType["BrandOutline"] = "brand-outline";
    BchatButtonType["Default"] = "default";
    BchatButtonType["DefaultOutline"] = "default-outline";
    BchatButtonType["Square"] = "square";
    BchatButtonType["SquareOutline"] = "square-outline";
    BchatButtonType["Simple"] = "simple";
    BchatButtonType["Medium"] = "medium";
})(BchatButtonType = exports.BchatButtonType || (exports.BchatButtonType = {}));
var BchatButtonColor;
(function (BchatButtonColor) {
    BchatButtonColor["Green"] = "green";
    BchatButtonColor["White"] = "white";
    BchatButtonColor["Primary"] = "primary";
    BchatButtonColor["Success"] = "success";
    BchatButtonColor["Secondary"] = "secondary";
    BchatButtonColor["Danger"] = "danger";
    BchatButtonColor["Warning"] = "warning";
    BchatButtonColor["None"] = "";
    BchatButtonColor["Red"] = "red";
    BchatButtonColor["Disable"] = "disable";
    BchatButtonColor["Enable"] = "enable";
})(BchatButtonColor = exports.BchatButtonColor || (exports.BchatButtonColor = {}));
const BchatButton = (props) => {
    const { buttonType, dataTestId, buttonColor, style = {}, text, disabled, onClick, iconSize, iconType, fillRule, clipRule } = props;
    const clickHandler = (e) => {
        if (onClick) {
            e.stopPropagation();
            onClick();
        }
    };
    const buttonTypes = [];
    const onClickFn = disabled ? () => null : clickHandler;
    buttonTypes.push(buttonType);
    return (react_1.default.createElement(react_1.default.Fragment, null, props.icon ? (react_1.default.createElement("div", { style: props.style, onClick: onClickFn, "data-testid": dataTestId }, props.children || text)) : (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-button', ...buttonTypes, buttonColor, disabled && 'disabled'), role: "button", onClick: onClickFn, "data-testid": dataTestId, style: style },
        iconType && iconSize && react_1.default.createElement("span", { style: { marginRight: '5px' } },
            react_1.default.createElement(icon_1.BchatIcon, { iconType: iconType, fillRule: fillRule, clipRule: clipRule, iconSize: iconSize })),
        props.children || text))));
};
exports.BchatButton = BchatButton;
exports.BchatButton.defaultProps = {
    disabled: false,
    buttonType: BchatButtonType.Default,
    buttonColor: BchatButtonColor.Primary,
    onClick: null,
};
