"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatDropdownItem = exports.BchatDropDownItemType = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const icon_1 = require("../icon");
var BchatDropDownItemType;
(function (BchatDropDownItemType) {
    BchatDropDownItemType["Default"] = "default";
    BchatDropDownItemType["Danger"] = "danger";
})(BchatDropDownItemType = exports.BchatDropDownItemType || (exports.BchatDropDownItemType = {}));
const BchatDropdownItem = (props) => {
    const clickHandler = (e) => {
        if (props.onClick) {
            e.stopPropagation();
            props.onClick();
        }
    };
    const { content, type, icon, active } = props;
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-dropdown__item', active ? 'active' : '', type || BchatDropDownItemType.Default), role: "button", onClick: clickHandler },
        icon ? react_1.default.createElement(icon_1.BchatIcon, { iconType: icon, iconSize: "small" }) : '',
        react_1.default.createElement("div", { className: "item-content" }, content)));
};
exports.BchatDropdownItem = BchatDropdownItem;
