"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatHtmlRenderer = void 0;
const react_1 = __importDefault(require("react"));
const dompurify_1 = __importDefault(require("dompurify"));
const BchatHtmlRenderer = ({ tag = 'div', key, html, className }) => {
    const clean = dompurify_1.default.sanitize(html, {
        USE_PROFILES: { html: true },
        FORBID_ATTR: ['script'],
    });
    return react_1.default.createElement(tag, {
        key,
        className,
        dangerouslySetInnerHTML: { __html: clean },
    });
};
exports.BchatHtmlRenderer = BchatHtmlRenderer;
