"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatRadio = void 0;
const react_1 = __importDefault(require("react"));
const Flex_1 = require("./Flex");
const BchatRadio = (props) => {
    const { label, group, value, active, onClick } = props;
    function clickHandler(e) {
        e.stopPropagation();
        onClick(value);
    }
    return (react_1.default.createElement(Flex_1.Flex, null,
        react_1.default.createElement("input", { type: "radio", name: group || '', value: value, "aria-checked": active, checked: active, onChange: clickHandler }),
        react_1.default.createElement("label", { role: "button", onClick: clickHandler }, label)));
};
exports.BchatRadio = BchatRadio;
