"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatToast = exports.BchatToastType = void 0;
const react_1 = __importDefault(require("react"));
const Flex_1 = require("./Flex");
const styled_components_1 = __importDefault(require("styled-components"));
const lodash_1 = require("lodash");
const icon_1 = require("../icon");
var BchatToastType;
(function (BchatToastType) {
    BchatToastType["Info"] = "info";
    BchatToastType["Success"] = "success";
    BchatToastType["Warning"] = "warning";
    BchatToastType["Error"] = "error";
})(BchatToastType = exports.BchatToastType || (exports.BchatToastType = {}));
const TitleDiv = styled_components_1.default.div `
  
  font-size: 18px;
  font-weight: 400;
  
`;
const DescriptionDiv = styled_components_1.default.div `
  font-size: var(--font-size-sm);
  color: var(--color-text-subtle);
  text-overflow: ellipsis;
  font-family: var(--font-default);
  padding-bottom: var(--font-size-xs);
  padding-top: var(--font-size-xs);
`;
const IconDiv = styled_components_1.default.div `
  flex-shrink: 0;
  padding-inline-end: var(--margins-xs);
`;
const BchatToast = (props) => {
    const { title, description, type, icon } = props;
    const toastDesc = description ? description : '';
    const toastIconSize = toastDesc ? 'huge' : 'large';
    let toastIcon = icon || undefined;
    let toastColor;
    if (!toastIcon) {
        switch (type) {
            case BchatToastType.Info:
                toastIcon = 'infoCircle';
                toastColor = '#2F8FFF';
                break;
            case BchatToastType.Success:
                toastIcon = 'check';
                toastColor = '#00A638';
                break;
            case BchatToastType.Error:
                toastIcon = 'error';
                toastColor = '#FF3C3C';
                break;
            case BchatToastType.Warning:
                toastIcon = 'warning';
                toastColor = '#F0AF13';
                break;
            default:
                toastIcon = 'info';
        }
    }
    return (react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center", onClick: props?.onToastClick || lodash_1.noop, "data-testid": "bchat-toast" },
        react_1.default.createElement(IconDiv, { style: { paddingLeft: '10px', paddingRight: '13px' } },
            react_1.default.createElement(icon_1.BchatIcon, { iconType: toastIcon, iconSize: toastIconSize, iconColor: toastColor })),
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "flex-start", flexDirection: "column", className: "bchat-toast" },
            react_1.default.createElement(TitleDiv, null, title),
            toastDesc && react_1.default.createElement(DescriptionDiv, null, toastDesc))));
};
exports.BchatToast = BchatToast;
