"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatToggle = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const react_redux_1 = require("react-redux");
const BchatToggle = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const clickHandler = (event) => {
        const stateManager = (e) => {
            e.stopPropagation();
            props.onClick();
        };
        if (props.confirmationDialogParams && props.confirmationDialogParams.shouldShowConfirm) {
            const closeConfirmModal = () => {
                dispatch((0, modalDialog_1.updateConfirmModal)(null));
            };
            dispatch((0, modalDialog_1.updateConfirmModal)({
                onClickOk: () => {
                    stateManager(event);
                    closeConfirmModal();
                },
                onClickClose: () => {
                    (0, modalDialog_1.updateConfirmModal)(null);
                },
                ...props.confirmationDialogParams,
                updateConfirmModal: modalDialog_1.updateConfirmModal,
            }));
            return;
        }
        stateManager(event);
    };
    return (react_1.default.createElement("div", { className: "bchat-settings-item__selection" },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-toggle', props.active ? 'active' : ''), role: "button", onClick: clickHandler },
            react_1.default.createElement("div", { className: "knob" }))));
};
exports.BchatToggle = BchatToggle;
