"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PillContainerHoverable = exports.PillTooltipWrapper = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const StyledPillContainerHoverable = styled_components_1.default.div `
  background: none;
  position: relative;
  flex-direction: 'column';
  flex-shrink: 0;
  max-width: 100%;
  white-space: nowrap;
  text-overflow: ellipsis;
  align-items: center;
  padding: ${props => props.padding || ''};
`;
const StyledPillInner = styled_components_1.default.div `
  display: flex;
  flex-direction: column;
  flex-grow: 1;
  flex-shrink: 0;
  font-family: 'OpenSans';
  font-weight: 400;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;

  align-items: center;
  padding: ${props => props.padding || ''};
  margin: ${props => props.margin || ''};
  border-radius: 16px;
  padding: 20px 0;
  background-color: var(--color-conversation-item-selected);
  cursor: pointer;
  // border: 1px solid var(--color-pill-divider);
  transition: var(--default-duration);
  &:hover {
    background: var(--color-clickable-hovered);
  }
`;
const PillTooltipWrapper = (props) => {
    return react_1.default.createElement(StyledPillContainerHoverable, { ...props }, props.children);
};
exports.PillTooltipWrapper = PillTooltipWrapper;
const PillContainerHoverable = (props) => {
    return react_1.default.createElement(StyledPillInner, { ...props }, props.children);
};
exports.PillContainerHoverable = PillContainerHoverable;
