"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallInFullScreenContainer = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const styled_components_1 = __importDefault(require("styled-components"));
const useVideoEventListener_1 = require("../../hooks/useVideoEventListener");
const call_1 = require("../../state/ducks/call");
const call_2 = require("../../state/selectors/call");
const CallButtons_1 = require("./CallButtons");
const DraggableCallContainer_1 = require("./DraggableCallContainer");
const Flex_1 = require("../basic/Flex");
const conversations_1 = require("../../state/selectors/conversations");
const AvatarPlaceHolder_1 = require("../avatar/AvatarPlaceHolder/AvatarPlaceHolder");
const utils_1 = require("../../bchat/utils");
const InConversationCallContainer_1 = require("./InConversationCallContainer");
const Avatar_1 = require("../avatar/Avatar");
const Text_1 = require("../basic/Text");
const theme_1 = require("../../state/selectors/theme");
const CallInFullScreenVisible = styled_components_1.default.div `
  position: absolute;
  z-index: 999;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  display: flex;
  flex-direction: column;
  opacity: 1;
  width: 100vw;
  align-items: center;

  background: ${props => props.bgColor};
  height: 100%;
  background-size: cover;
`;
const StyledLocalVideoContainer = styled_components_1.default.div `
  width: 18%;
  bottom: 30px;
  right: 10px;
  border-radius: 16px;
  overflow: hidden;
  position: absolute;
`;
const StyledLocalVideoElement = styled_components_1.default.video `
  width:100%;
  transform: rotateY(180deg);
  opacity: ${props => (props.isVideoMuted ? 0 : 1)};
`;
const StyledFlex = (0, styled_components_1.default)(Flex_1.Flex) `
  position: absolute;
  bottom: 20px;
  height: 90px;
`;
const CallInFullScreenContainer = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const ongoingCallWithFocused = (0, react_redux_1.useSelector)(call_2.getHasOngoingCallWithFocusedConvo);
    const hasOngoingCallFullScreen = (0, react_redux_1.useSelector)(call_2.getCallIsInFullScreen);
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversation);
    const ourPubkey = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const [isPortrait, setPortrait] = (0, react_1.useState)(false);
    const avatarBgColor = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark' ? '#131313' : '#FFF';
    const { remoteStream, remoteStreamVideoIsMuted, localStream, currentConnectedAudioInputs, currentConnectedAudioOutputs, currentConnectedCameras, isAudioMuted, isAudioOutputMuted, localStreamVideoIsMuted, } = (0, useVideoEventListener_1.useVideoCallEventsListener)('CallInFullScreenContainer', true);
    const videoRefRemote = react_1.default.useRef(null);
    const videoRefLocal = react_1.default.useRef(null);
    function toggleFullScreenOFF() {
        dispatch((0, call_1.setFullScreenCall)(false));
    }
    (0, useKey_1.default)('Escape', () => {
        toggleFullScreenOFF();
    });
    (0, react_1.useEffect)(() => {
        if (remoteStreamVideoIsMuted) {
            dispatch((0, call_1.setFullScreenCall)(false));
        }
    }, [remoteStreamVideoIsMuted]);
    (0, react_1.useEffect)(() => {
        if (!videoRefRemote.current)
            return;
        const videoEl = videoRefRemote.current;
        const handleVideoResize = () => {
            if (!videoEl.videoWidth || !videoEl.videoHeight)
                return;
            if (videoEl.videoWidth < videoEl.videoHeight) {
                setPortrait(true);
            }
            else {
                setPortrait(false);
            }
        };
        videoEl.addEventListener('loadedmetadata', handleVideoResize);
        return () => {
            videoEl.removeEventListener('loadedmetadata', handleVideoResize);
        };
    }, [remoteStream, hasOngoingCallFullScreen]);
    if (!ongoingCallWithFocused || !hasOngoingCallFullScreen) {
        return null;
    }
    if (videoRefRemote?.current) {
        if (videoRefRemote.current.srcObject !== remoteStream) {
            videoRefRemote.current.srcObject = remoteStream;
        }
    }
    if (videoRefLocal?.current) {
        if (videoRefLocal.current.srcObject !== localStream) {
            videoRefLocal.current.srcObject = localStream;
        }
    }
    const validateMemberName = (memberName) => {
        if (memberName == selectedConversation?.id) {
            let staringTwoString = memberName.substring(0, 2);
            let lastString = memberName.substring(58, 66);
            return `${staringTwoString}...${lastString}`;
        }
        return memberName;
    };
    const getBgColor = (privateKey, avoidColor) => {
        const index = (privateKey ? AvatarPlaceHolder_1.cachedHashes.get(privateKey) ?? 0 : 0) % AvatarPlaceHolder_1.avatarPlaceholderColors.length;
        const { bgColor } = AvatarPlaceHolder_1.avatarPlaceholderColors[index];
        if (bgColor !== avoidColor)
            return bgColor;
        const alternatives = AvatarPlaceHolder_1.avatarPlaceholderColors.filter(c => c.bgColor !== avoidColor);
        return alternatives[Math.floor(Math.random() * alternatives.length)].bgColor;
    };
    const ourPubkeyColor = getBgColor(ourPubkey);
    const selectedConvoColor = getBgColor(selectedConversation?.id, ourPubkeyColor);
    return (react_1.default.createElement(CallInFullScreenVisible, { className: "blur-layer", bgColor: `linear-gradient(${selectedConvoColor},${ourPubkeyColor})` },
        react_1.default.createElement(DraggableCallContainer_1.StyledVideoElement, { ref: videoRefRemote, autoPlay: true, isVideoMuted: remoteStreamVideoIsMuted, width: isPortrait ? '700px' : '100%' }),
        react_1.default.createElement(StyledLocalVideoContainer, null,
            react_1.default.createElement(StyledLocalVideoElement, { ref: videoRefLocal, autoPlay: true, isVideoMuted: localStreamVideoIsMuted }),
            localStreamVideoIsMuted && (react_1.default.createElement(InConversationCallContainer_1.CenteredAvatarInConversation, { isNeedBgColor: !remoteStreamVideoIsMuted && localStreamVideoIsMuted, avatarBgColor: avatarBgColor, isFullScreen: hasOngoingCallFullScreen },
                react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.XXXL, pubkey: ourPubkey, isBnsHolder: selectedConversation?.isBnsHolder }),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement(InConversationCallContainer_1.UserNameTxt, null, validateMemberName(selectedConversation?.profileName))))),
        react_1.default.createElement(StyledFlex, { container: true, width: "100%", justifyContent: "center", alignItems: "center" },
            react_1.default.createElement(CallButtons_1.CallWindowControls, { currentConnectedAudioInputs: currentConnectedAudioInputs, currentConnectedAudioOutputs: currentConnectedAudioOutputs, currentConnectedCameras: currentConnectedCameras, isAudioMuted: isAudioMuted, isAudioOutputMuted: isAudioOutputMuted, localStreamVideoIsMuted: localStreamVideoIsMuted, remoteStreamVideoIsMuted: remoteStreamVideoIsMuted, isFullScreen: hasOngoingCallFullScreen, selectedName: validateMemberName(selectedConversation?.profileName || selectedConversation?.id) }))));
};
exports.CallInFullScreenContainer = CallInFullScreenContainer;
