"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddMentions = void 0;
const classnames_1 = __importDefault(require("classnames"));
const types_1 = require("../../bchat/types");
const utils_1 = require("../../bchat/utils");
const conversations_1 = require("../../bchat/conversations");
const react_1 = __importDefault(require("react"));
const Mention = (props) => {
    const foundConvo = (0, conversations_1.getConversationController)().get(props.text.slice(1));
    let us = false;
    if (foundConvo) {
        us = utils_1.UserUtils.isUsFromCache(foundConvo.id);
    }
    if (foundConvo) {
        const className = (0, classnames_1.default)('mention-profile-name', us && 'mention-profile-name-us');
        const displayedName = foundConvo.getContactProfileNameOrShortenedPubKey();
        return react_1.default.createElement("span", { className: className },
            "@",
            displayedName);
    }
    else {
        return react_1.default.createElement("span", { className: "mention-profile-name" }, types_1.PubKey.shorten(props.text));
    }
};
const defaultRenderOther = ({ text }) => react_1.default.createElement(react_1.default.Fragment, null, text);
const AddMentions = (props) => {
    const { text, renderOther, isGroup } = props;
    const results = [];
    const FIND_MENTIONS = new RegExp(`@${types_1.PubKey.regexForPubkeys}`, 'g');
    const renderWith = renderOther || defaultRenderOther;
    let match = FIND_MENTIONS.exec(text);
    let last = 0;
    let count = 1000;
    if (!match) {
        return renderWith({ text, key: 0, isGroup });
    }
    while (match) {
        count++;
        const key = count;
        if (last < match.index) {
            const otherText = text.slice(last, match.index);
            results.push(renderWith({ text: otherText, key, isGroup }));
        }
        const pubkey = text.slice(match.index, FIND_MENTIONS.lastIndex);
        results.push(react_1.default.createElement(Mention, { text: pubkey, key: `${key}` }));
        last = FIND_MENTIONS.lastIndex;
        match = FIND_MENTIONS.exec(text);
    }
    if (last < text.length) {
        results.push(renderWith({ text: text.slice(last), key: count++, isGroup }));
    }
    return react_1.default.createElement(react_1.default.Fragment, null, results);
};
exports.AddMentions = AddMentions;
