"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatEmojiPanel = exports.StyledEmojiPanel = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const data_1 = __importDefault(require("@emoji-mart/data"));
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
const styled_components_1 = __importDefault(require("styled-components"));
const emoji_mart_1 = require("emoji-mart");
const lodash_1 = require("lodash");
const i18n_1 = require("../../util/i18n");
const pickerProps = {
    title: '',
    showPreview: true,
    autoFocus: true,
    skinTonePosition: 'preview',
};
exports.StyledEmojiPanel = styled_components_1.default.div `
  padding: var(--margins-lg);
  z-index: 5;
  opacity: 0;
  visibility: hidden;
  transition: var(--default-duration);
  button:focus {
    outline: none;
  }
  &.show {
    opacity: 1;
    visibility: visible;
    ${props => !props.isModal &&
    `
    position: absolute;
    left: 42px;
    bottom: 61px;

      `}
  }
       
  

  em-emoji-picker {
    font-family: var(--font-default);
    font-size: var(--font-size-sm);
    background-color: var(--color-emoji-panel-bg);
    border: 1px solid var(--color-bchat-border);
    border-radius: 8px;
    padding-bottom: var(--margins-sm);

    ${props => {
    switch (props.theme) {
        case 'dark':
            return `
            --background-color: var(--color-emoji-panel-bg);
            --rgb-background: var(--color-emoji-panel-bg);
            --rgb-color: 255, 255, 255; // var(--color-text)
            --rgb-input: 27, 27, 27;
             --rgb-accent: 16, 141, 50;
        
          `;
        case 'light':
        default:
            return `
            --background-color: var(--color-emoji-panel-bg);
            --rgb-background: var(--color-emoji-panel-bg);
            --rgb-color: 0, 0, 0; // var(--color-text)
            --rgb-input: 249, 249, 249;
            --rgb-accent: 16, 141, 50;
        `;
    }
}}
    ${props => !props.isModal &&
    `
      &:after {
        content: '';
        position: absolute;
        top: calc(100% - 42px);
        left: 44px;
        width: 22px;
        height: 22px;
        background-color: var(--color-emoji-panel-bg);
        transform: rotate(45deg);
        border-radius: 3px;
        transform: scaleY(1.4) rotate(45deg);
        border: 0.7px solid var(--color-bchat-border);
        clip-path: polygon(100% 100%, 7.2px 100%, 100% 7.2px);
      }
    `}
  }
`;
const categoryIcons = {
    frequent: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
  <g opacity="0.4">
    <path fill-rule="evenodd" clip-rule="evenodd" d="M11 1.75C9.17053 1.75 7.38213 2.2925 5.86098 3.30891C4.33983 4.32531 3.15423 5.76996 2.45412 7.46018C1.75401 9.15039 1.57083 11.0103 1.92774 12.8046C2.28465 14.5989 3.16563 16.2471 4.45927 17.5407C5.7529 18.8344 7.4011 19.7154 9.19542 20.0723C10.9897 20.4292 12.8496 20.246 14.5398 19.5459C16.23 18.8458 17.6747 17.6602 18.6911 16.139C19.7075 14.6179 20.25 12.8295 20.25 11C20.25 8.54675 19.2755 6.19397 17.5407 4.45926C15.806 2.72455 13.4533 1.75 11 1.75ZM5.02763 2.0617C6.79545 0.880476 8.87386 0.25 11 0.25C13.8511 0.25 16.5854 1.38259 18.6014 3.3986C20.6174 5.41462 21.75 8.14892 21.75 11C21.75 13.1261 21.1195 15.2046 19.9383 16.9724C18.7571 18.7402 17.0782 20.1181 15.1139 20.9317C13.1495 21.7453 10.9881 21.9582 8.90278 21.5434C6.81749 21.1287 4.90202 20.1048 3.39861 18.6014C1.89519 17.098 0.871354 15.1825 0.456563 13.0972C0.0417719 11.0119 0.254658 8.85046 1.0683 6.88615C1.88194 4.92185 3.2598 3.24293 5.02763 2.0617ZM10.6299 5.75977C11.0441 5.75977 11.3799 6.09555 11.3799 6.50977V10.5872C11.3947 10.8076 11.4592 11.0219 11.5687 11.214C11.6783 11.4065 11.8301 11.5714 12.0126 11.6967L15.0942 13.5357C15.4499 13.748 15.5662 14.2084 15.3539 14.5641C15.1417 14.9198 14.6812 15.0361 14.3255 14.8238L11.2255 12.9738C11.2145 12.9672 11.2036 12.9603 11.1928 12.9531C10.8106 12.6974 10.4931 12.3562 10.2654 11.9566C10.0377 11.557 9.90612 11.1099 9.881 10.6507C9.88026 10.6371 9.87988 10.6234 9.87988 10.6098V6.50977C9.87988 6.09555 10.2157 5.75977 10.6299 5.75977Z" fill="var(--color-emoji-header-icon)"/>
  </g>
</svg>`,
    },
    people: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
  <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M8.79863 19.9774L8.80054 19.9774C9.1989 19.9845 9.59722 19.9916 9.99548 20C9.99632 19.9891 9.99632 19.9782 9.99548 19.9647C10.2227 19.9647 10.4498 19.9652 10.677 19.9656C11.1766 19.9665 11.6768 19.9674 12.1764 19.9639C13.4698 19.9547 14.7632 19.9303 16.0348 19.6516C17.8417 19.2545 19.0536 18.2052 19.5772 16.4078C19.7999 15.6447 19.9041 14.859 19.931 14.0698C19.967 13.0113 19.9786 11.9517 19.9903 10.8923C19.9934 10.6158 19.9964 10.3394 19.9999 10.063C20.0016 9.94208 19.9839 9.8128 19.9385 9.70282C19.8108 9.39137 19.478 9.22683 19.1544 9.29483C18.8292 9.36283 18.6006 9.64742 18.5981 10.0092C18.5956 10.3272 18.5959 10.6452 18.5962 10.9631C18.5966 11.415 18.5971 11.8668 18.5897 12.3187C18.572 13.4142 18.5434 14.5089 18.3333 15.5902C18.056 17.0223 17.25 17.9399 15.7986 18.2665C14.7556 18.5007 13.6967 18.5452 12.6369 18.5586C10.9435 18.5796 9.24834 18.5804 7.55489 18.5611C6.37157 18.5485 5.18657 18.5225 4.02931 18.2203C2.93676 17.9349 2.18038 17.2893 1.82488 16.2005C1.56182 15.392 1.46434 14.5551 1.45005 13.7147C1.41475 11.6605 1.39878 9.60544 1.40635 7.55121C1.41055 6.3625 1.44417 5.17126 1.7484 4.00857C2.05599 2.8316 2.788 2.04584 3.97132 1.76797C4.71594 1.59336 5.48744 1.47415 6.25055 1.454C8.30623 1.39943 10.3644 1.39608 12.4218 1.40363C13.6118 1.40783 14.8052 1.43973 15.9692 1.74279C17.1719 2.05675 17.9677 2.7997 18.2375 4.01528C18.3755 4.63558 18.4428 5.27245 18.5099 5.907C18.5212 6.01442 18.5326 6.12182 18.5443 6.22902C18.5905 6.66219 18.8762 6.98204 19.2721 6.96777C19.6772 6.9535 19.9822 6.62778 19.9411 6.19124C19.9291 6.06421 19.9177 5.93696 19.9064 5.80965C19.8507 5.18565 19.7948 4.55984 19.6671 3.9498C19.2796 2.09873 18.1787 0.88063 16.3205 0.386171C15.2229 0.0940285 14.0993 0.0260305 12.9739 0.0142776C10.9897 -0.00587012 9.00462 -0.00334991 7.02038 0.0134399C5.9959 0.0218348 4.97395 0.088992 3.96796 0.310617C2.02742 0.738757 0.806283 1.89893 0.341528 3.83983C0.0885607 4.89843 0.0221681 5.97801 0.0129234 7.05843C-0.00388504 9.01192 -0.00472546 10.9654 0.0129234 12.9181C0.0230085 14.0203 0.0885617 15.1226 0.358338 16.1996C0.789475 17.9197 1.84169 19.0514 3.55615 19.5509C4.33438 19.7775 5.13531 19.8791 5.94043 19.9085C6.89294 19.9434 7.84587 19.9604 8.79863 19.9774ZM8.13246 6.87059C8.13246 7.44346 7.66807 7.90785 7.0952 7.90785C6.52234 7.90785 6.05794 7.44346 6.05794 6.87059C6.05794 6.29773 6.52234 5.83333 7.0952 5.83333C7.66807 5.83333 8.13246 6.29773 8.13246 6.87059ZM12.9041 7.90785C13.477 7.90785 13.9414 7.44346 13.9414 6.87059C13.9414 6.29773 13.477 5.83333 12.9041 5.83333C12.3313 5.83333 11.8669 6.29773 11.8669 6.87059C11.8669 7.44346 12.3313 7.90785 12.9041 7.90785ZM5.90261 11.6789C6.81831 13.0581 8.34993 13.8814 10 13.8814C11.6499 13.8814 13.1817 13.0581 14.0974 11.6789C14.2241 11.4883 14.1721 11.2304 13.9812 11.1039C13.7899 10.9767 13.5327 11.029 13.4062 11.22C12.6446 12.367 11.3713 13.0518 10 13.0518C8.62874 13.0518 7.3554 12.367 6.59384 11.22C6.4673 11.0292 6.20964 10.9767 6.01879 11.1039C5.82793 11.2304 5.77586 11.4881 5.90261 11.6789Z" fill="var(--color-emoji-header-icon)"/>
</svg>`,
    },
    nature: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
  <g opacity="0.4">
    <path d="M10.549 16.4484C10.6085 16.51 10.701 16.5563 10.8409 16.5563C11.2662 16.5563 11.2841 16.1456 11.2841 16.141L12.1167 16.1785V16.1822C12.0904 16.7679 11.6344 17.3893 10.8409 17.3893C10.5198 17.3893 10.2291 17.2764 10.0079 17.0757C9.78637 17.2764 9.49565 17.3893 9.17495 17.3893C8.38151 17.3893 7.92586 16.7679 7.89921 16.1822V16.1785L8.73179 16.141C8.73179 16.1456 8.75012 16.5563 9.17495 16.5563C9.31489 16.5563 9.40694 16.51 9.46691 16.4484C9.58603 16.3264 9.58145 16.1456 9.58145 16.1456V15.2347C8.92838 14.9369 8.16952 14.0834 8.16952 13.5307C8.16952 12.8514 8.85632 12.8514 8.85632 12.8514H11.1471C11.1471 12.8514 11.8343 12.8514 11.8343 13.5307C11.8343 14.0805 11.0846 14.9256 10.434 15.2284V16.1456C10.434 16.1456 10.4299 16.3264 10.549 16.4484Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M13.7409 9.10118C13.2811 9.10118 12.9079 9.66098 12.9079 10.3511C12.9079 11.0405 13.2811 11.6003 13.7409 11.6003C14.2011 11.6003 14.5739 11.0405 14.5739 10.3511C14.5739 9.66098 14.2011 9.10118 13.7409 9.10118Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M5.41024 10.3516C5.41024 9.66143 5.78343 9.10163 6.24324 9.10163C6.70347 9.10163 7.07624 9.66143 7.07624 10.3516C7.07624 11.0409 6.70347 11.6007 6.24324 11.6007C5.78343 11.6007 5.41024 11.0409 5.41024 10.3516Z" fill="var(--color-emoji-header-icon)"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M17.8469 8.11344C19.0398 6.73435 20.6408 3.6084 18.4288 1.27674C17.6533 0.459541 16.6903 0.0184505 15.6432 0.000956867C13.5803 -0.033614 11.9022 1.56206 11.7177 1.74408C11.2662 1.65452 10.7823 1.60413 10.2625 1.60413C9.58941 1.60413 8.97049 1.68951 8.39864 1.83529L8.30201 1.74699L8.29868 1.74449C8.11417 1.56206 6.43609 -0.033614 4.37317 0.000540351C3.3265 0.018034 2.36314 0.459124 1.5872 1.27716C-0.619833 3.6034 0.969947 6.72019 2.16155 8.10427C1.33563 8.87983 -0.592344 11.0415 0.178181 13.7714C1.3044 17.7641 4.82632 17.8991 5.06206 17.9032H5.69639C6.78178 19.3144 8.63646 19.9492 10.0072 19.9492C11.2658 19.9492 13.133 19.4106 14.2904 17.9032H14.9256C15.1738 17.8991 18.6958 17.7641 19.822 13.7714C20.5904 11.047 18.6724 8.88941 17.8469 8.11344ZM18.6189 13.4317C17.7505 16.511 15.2011 16.6481 14.9254 16.6539H13.8379C13.5068 16.6539 13.2381 16.9117 13.2165 17.2374C12.3131 18.3254 10.8662 18.6994 10.0069 18.6994C9.16644 18.6994 7.73784 18.3387 6.82821 17.3033C6.8284 17.2992 6.82904 17.2954 6.82968 17.2917C6.83041 17.2874 6.83112 17.2831 6.83112 17.2787C6.83112 16.933 6.55165 16.6539 6.20637 16.6539H5.08599C4.79819 16.6481 2.24879 16.511 1.38039 13.4317C0.657761 10.8718 3.16759 8.87422 3.27088 8.79342L3.58284 8.551L3.70196 8.17614C3.77026 7.95913 5.44501 2.8539 10.2622 2.8539C14.9999 2.8539 16.2224 7.86875 16.2711 8.07784L16.3735 8.51602L16.7247 8.79008C16.8317 8.87422 19.3411 10.8718 18.6189 13.4317ZM4.39576 1.25029C3.76226 1.2607 3.10294 1.49728 2.49527 2.13747C0.893827 3.82561 2.20663 6.06313 2.84929 6.95198C3.40532 5.72367 4.6973 3.4749 7.06302 2.32448C6.53823 1.90963 5.50864 1.23155 4.39576 1.25029ZM15.622 1.25028C16.2555 1.26028 16.9152 1.49686 17.5221 2.13704C19.0948 3.79394 17.8599 5.97899 17.206 6.89949C16.7207 5.60787 15.5479 3.27955 13.1268 2.19286C13.6861 1.78092 14.6212 1.23362 15.622 1.25028Z" fill="var(--color-emoji-header-icon)"/>
  </g>
</svg>
  `,
    },
    foods: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
  <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M19.3333 12.3908C19.3525 12.6133 18.6383 12.8696 18.6383 12.8696L20 13.6582C20 13.6582 19.8076 13.8912 19.4197 14.1028C19.9086 14.4902 19.9829 14.9202 19.9829 15.3723C19.9829 15.9288 19.7687 16.4118 19.0482 16.8635C19.4064 17.1896 19.7591 18.3919 19.7591 18.7634C19.7591 19.3988 17.9499 20.0104 17.5333 20.0104C17.1154 20.0104 13.7612 20.015 11.4807 20.015C10.4667 20.015 9.50198 20.0204 8.60906 20.015L1.60175 19.9962L0 4.56415H7.33709L8.35942 0.449193H8.36151C8.42705 0.191617 8.65832 0 8.93592 0C8.98977 0 9.04112 0.0100192 9.09038 0.0229606L9.09163 0.0208733L9.16552 0.0463387C9.16677 0.0467561 9.16719 0.0467561 9.16802 0.0475911L13.2202 1.43232L12.8362 2.55739L9.35629 1.36762L8.56189 4.56415H10.4367L10.0664 8.36517C10.5523 8.34012 11.0507 8.32635 11.5613 8.32635C16.0476 8.32635 19.7007 9.27441 19.7007 11.5124C19.7007 11.9299 19.4761 11.9449 19.2415 12.3236C19.2724 12.344 19.3304 12.352 19.3333 12.3908ZM5.19351 18.435C5.61639 18.8533 6.59531 18.7636 6.59531 18.7636H17.0971C17.0971 18.7636 17.5905 18.7598 17.9704 18.3841C18.5152 17.8451 17.846 17.0828 17.1685 17.0828C15.8347 17.0828 7.41267 17.072 5.86769 17.072C5.17598 17.072 4.77064 18.0159 5.19351 18.435ZM1.31467 5.81593L2.60292 18.7628H3.36142C3.3514 18.3912 3.79348 17.2282 4.15082 16.9021C3.4303 16.4509 3.09425 16.0459 3.09425 15.489C3.09425 15.0114 3.22325 14.3644 3.76426 13.9607C3.09091 13.729 2.97904 13.2543 3.4111 13.127C3.88991 12.9847 3.94376 13.3128 4.22805 12.9471C3.67409 12.3989 3.36142 12.1677 3.36142 11.5118C3.36142 9.73927 5.69663 8.77911 8.8943 8.45515L9.18693 5.81593H1.31467ZM11.5634 9.53924C9.1459 9.53924 4.50136 10.0732 4.58903 11.5339C4.61574 11.9756 6.24755 12.5007 6.24755 12.5007H16.8925C16.8925 12.5007 18.5043 11.9276 18.5156 11.5339C18.5586 10.0719 13.9044 9.53924 11.5634 9.53924ZM0 4.56415C0 4.59919 0.016267 4.74977 0 4.56415V4.56415Z" fill="var(--color-emoji-header-icon)"/>
</svg>`,
    },
    activity: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
  <path opacity="0.4" d="M10 0C4.48611 0 0 4.48611 0 10C0 15.5139 4.48611 20 10 20C15.5139 20 20 15.5139 20 10C20 4.48611 15.5139 0 10 0ZM10 1.5C10.7674 1.5 11.5069 1.61024 12.2127 1.79948L10 3.38455L7.78733 1.79948C8.49306 1.61024 9.23264 1.5 10 1.5ZM6.625 2.19705L9.5 4.25694V6.26042L6.4401 8.45312L4.40712 7.77517L3.38194 4.66493C4.24132 3.59983 5.35069 2.7474 6.625 2.19705ZM13.375 2.19705C14.6493 2.7474 15.7587 3.59983 16.6181 4.66493L15.5929 7.77517L13.5599 8.45312L10.5 6.26042V4.25694L13.375 2.19705ZM2.67188 5.70226L3.40972 7.94358L1.53646 9.28646C1.6441 7.98438 2.04514 6.76997 2.67188 5.70226ZM17.3281 5.70226C17.9549 6.76997 18.3559 7.98438 18.4635 9.28646L16.5903 7.94358L17.3281 5.70226ZM10 7.13281L12.9097 9.21788L11.8021 12.5799H8.19792L7.09028 9.21788L10 7.13281ZM4.05382 8.71181L6.09462 9.39236L7.28906 13.0139L6.14844 14.4705L2.78906 14.4913C2.06337 13.3273 1.61458 11.9757 1.52604 10.5226L4.05382 8.71181ZM15.9453 8.71181L18.474 10.5226C18.3854 11.9757 17.9366 13.3273 17.2109 14.4913L13.9062 14.4714L12.7274 12.9661L13.9054 9.39236L15.9453 8.71181ZM8.11545 13.5799H11.9384L13.0616 15.0156L11.9314 18.2726C11.3108 18.4167 10.6658 18.5 10 18.5C9.31424 18.5 8.65104 18.4106 8.01302 18.2578L6.91927 15.1076L8.11545 13.5799ZM5.98698 15.4714L6.82465 17.8828C5.52951 17.362 4.39497 16.5347 3.50868 15.487L5.98698 15.4714ZM13.9618 15.4714L16.4913 15.487C15.592 16.5503 14.4358 17.3854 13.1172 17.9045L13.9618 15.4714Z" fill="var(--color-emoji-header-icon)"/>
</svg>`,
    },
    places: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
  <g opacity="0.4">
    <path d="M12.9165 0H4.16777L4.17637 7.48633H0V18.7352H1.2487V8.74951H5.40627L5.41696 1.25006H11.6661V7.49945H12.9141V6.24984H18.7466V18.7348H19.9997V4.98621H12.9165V0Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M3.75265 9.98599H2.50283V11.2359H3.75265V9.98599Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M9.16981 4.99978H10.4196V6.24965H9.16981V4.99978Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M7.92042 4.99978H6.6706V6.24965H7.92042V4.99978Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M16.2512 7.48633H17.501V8.7362H16.2512V7.48633Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M17.501 9.98644H16.2512V11.2363H17.501V9.98644Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M6.6706 2.48609L7.92042 2.49901V3.74888H6.6706V2.48609Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M10.4196 2.50012H9.16981V3.74999H10.4196V2.50012Z" fill="var(--color-emoji-header-icon)"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9982 13.3321H16.2505C16.7107 13.3321 17.0837 13.7052 17.0837 14.1654V17.4984C17.0837 17.9582 16.7113 18.331 16.2516 18.3316V19.9975H13.752V18.3316H6.24936V19.9975H3.74972V18.3316C3.29073 18.3302 2.91907 17.9577 2.91907 17.4984V14.1654C2.91907 13.7052 3.29211 13.3321 3.75228 13.3321H5.00083L5.00023 12.0816C5.0741 9.9812 6.80435 8.32009 8.90592 8.33198H11.0931C13.1947 8.32009 14.9249 9.9812 14.9988 12.0816L14.9982 13.3321ZM10.002 9.58197C13.7515 9.58197 13.7515 11.4255 13.7515 13.3316H6.25256C6.25256 11.4276 6.25256 9.58197 10.002 9.58197ZM6.12213 15.1939C6.12213 14.6761 5.70245 14.2565 5.18476 14.2565C4.66707 14.2565 4.24739 14.6761 4.24739 15.1939C4.24739 15.7116 4.66707 16.1313 5.18476 16.1313C5.70245 16.1313 6.12213 15.7116 6.12213 15.1939ZM14.7907 14.2565C15.3084 14.2565 15.7281 14.6761 15.7281 15.1939C15.7281 15.7116 15.3084 16.1313 14.7907 16.1313C14.273 16.1313 13.8533 15.7116 13.8533 15.1939C13.8533 14.6763 14.2732 14.2567 14.7907 14.2565ZM16.2516 16.6638H3.75334V17.4842H16.2516V16.6638Z" fill="var(--color-emoji-header-icon)"/>
  </g>
</svg>`,
    },
    objects: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="14" height="20" viewBox="0 0 14 20" fill="none">
  <g opacity="0.4">
    <path d="M7.82396 9.46598C7.82396 9.53119 7.83154 9.59463 7.84588 9.65547L7.00387 10.4322L6.15698 9.65097C6.17064 9.59151 6.17785 9.52958 6.17785 9.46598C6.17785 9.0114 5.80936 8.6429 5.35481 8.6429C4.90026 8.6429 4.53177 9.0114 4.53177 9.46598C4.53177 9.92055 4.90026 10.289 5.35481 10.289C5.42539 10.289 5.49389 10.2802 5.55926 10.2635L6.58984 11.2141V13.9924H7.41288V11.2187L8.4472 10.2646C8.51117 10.2806 8.57809 10.289 8.647 10.289C9.10155 10.289 9.47004 9.92055 9.47004 9.46598C9.47004 9.0114 9.10155 8.6429 8.647 8.6429C8.19245 8.6429 7.82396 9.0114 7.82396 9.46598Z" fill="var(--color-emoji-header-icon)"/>
    <path d="M5.35391 17.696H6.99999V16.8729H5.35391V17.696Z" fill="var(--color-emoji-header-icon)"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.89216 18.506L9.83845 18.5047H9.89216V16.0944L10.0189 15.0211C10.1939 13.6098 10.8867 12.3138 11.9629 11.3843C13.3182 10.1646 14.0628 8.40668 13.9958 6.58458C13.9958 2.95401 10.8572 0 7 0C3.14282 0 0.00415429 2.95401 0.00415429 6.58458C-0.0627756 8.40668 0.681798 10.1646 2.03706 11.3843C3.11329 12.3138 3.80607 13.6098 3.98109 15.0211L4.10784 16.0956V18.506C4.12038 19.0518 4.52549 19.5086 5.06585 19.5862C5.70556 19.6897 6.35204 19.7457 7 19.7537C7.64796 19.7457 8.29444 19.6897 8.93415 19.5862C9.47451 19.5086 9.87962 19.0518 9.89216 18.506ZM11.1385 10.467C9.86333 11.568 9.02575 13.1212 8.80212 14.8148H5.20055C4.97467 13.1169 4.13742 11.5662 2.84537 10.4504C1.78094 9.49206 1.18576 8.08683 1.24009 6.585C1.24009 3.65363 3.8098 1.23503 7.00138 1.23503C10.193 1.23503 12.7627 3.65363 12.7635 6.63032C12.817 8.08683 12.2218 9.49206 11.1385 10.467ZM5.34377 16.0495H8.65898V18.3805C8.0932 18.4671 7.54019 18.5127 6.98598 18.5196C6.45498 18.5127 5.89716 18.4661 5.34346 18.3804L5.34377 16.0495Z" fill="var(--color-emoji-header-icon)"/>
  </g>
</svg>`,
    },
    symbols: {
        svg: ` <svg xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18" fill="none">
  <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M11.8617 0L11.8347 5.59323C11.8347 5.59323 10.7907 5.33852 10.0662 5.74131C8.91156 6.38512 8.9186 7.29881 9.17367 8.00704C9.62013 9.24726 12.9764 8.64862 12.9764 6.25702V1.47272C12.9764 1.47272 14.5886 2.2909 14.6986 3.82174C14.7418 4.42162 14.4719 4.9069 14.2536 5.29956C14.0378 5.68769 13.8724 5.98532 14.1092 6.21371C14.1092 6.21371 15.4649 4.96386 15.4897 3.76806C15.5434 1.09732 13.6302 0 11.8617 0ZM7.25603 17.75H5.88629L5.14588 16.9211C4.51968 17.4811 3.71207 17.7956 2.8721 17.8067C1.44571 17.8067 0.362132 16.9541 0.362132 15.6342C0.362132 14.6521 0.9626 14.049 1.78926 13.5829C1.88181 13.5273 1.97992 13.4777 2.0832 13.4281C1.59305 12.9035 1.16843 12.3845 1.16843 11.6996C1.16843 10.7459 1.97399 9.95956 3.10126 9.95956C4.163 9.95956 5.03408 10.6633 5.03408 11.707C5.03408 12.6462 4.3096 13.1819 3.47664 13.6291L5.06222 15.4628C5.33245 14.8806 5.45854 14.2419 5.42983 13.6006V13.3133H6.39939V13.6336C6.44732 14.5302 6.23754 15.4217 5.79485 16.2029L7.25603 17.75ZM2.64191 14.0767C2.56046 14.1152 2.4842 14.1541 2.40794 14.1982C1.81969 14.5184 1.41691 14.9112 1.41728 15.5513C1.41728 16.4295 2.12251 16.7678 2.92844 16.7678C3.51519 16.7939 4.08752 16.5815 4.51513 16.1788L2.64191 14.0767ZM2.92301 13.0323C3.58158 12.6956 4.05472 12.3642 4.05472 11.7569C4.07056 11.4087 3.89344 11.08 3.59389 10.9018C3.29434 10.7235 2.92098 10.7246 2.62248 10.9046C2.32399 11.0847 2.1488 11.4144 2.16669 11.7625C2.16669 12.1441 2.35171 12.4639 2.92301 13.0323ZM12.7791 13.8944L10.1248 17.7947L8.77573 17.8295L11.7588 13.7634L14.495 9.97978H15.8055L12.7791 13.8944ZM4.44333 3.50919H3.33272V4.06596L0 4.06691V2.95404H7.77424V4.06469L4.44333 4.06564V3.50919ZM4.44333 4.06564V8.50711H3.33272V4.06596L4.44333 4.06564ZM7.77424 0.732537H0V1.84319H7.77424V0.732537ZM13.7776 15.7851C13.7776 15.1828 14.0041 14.7385 14.4673 14.7385C14.9115 14.7385 15.1473 15.158 15.1473 15.7951V15.8395C15.1473 16.4815 14.8915 16.9009 14.4624 16.9009C14.0234 16.9009 13.7776 16.4715 13.7776 15.8295V15.7851ZM14.4473 17.7645C13.4726 17.7645 12.9173 16.9341 12.9173 15.8863V15.7316C12.9173 14.7109 13.4885 13.8805 14.4581 13.8805C15.4276 13.8805 15.9992 14.6994 15.9992 15.7416V15.8975C15.9992 16.9063 15.4384 17.7645 14.4473 17.7645ZM9.3364 11.8888C9.3364 11.2894 9.56222 10.847 10.0231 10.847C10.4648 10.847 10.7002 11.2646 10.7002 11.8984V11.9424C10.7002 12.5814 10.4459 12.999 10.0183 12.999C9.58147 12.999 9.3364 12.5714 9.3364 11.9328V11.8888ZM10.0043 13.8673C9.02957 13.8673 8.47427 13.0369 8.47427 11.9892V11.8359C8.47427 10.8152 9.04549 9.98483 10.015 9.98483C10.9846 9.98483 11.5562 10.8038 11.5562 11.8459V12.0003C11.5562 13.0091 10.9953 13.8673 10.0043 13.8673Z" fill="var(--color-emoji-header-icon)"/>
</svg>`,
    },
    flags: {
        svg: `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18" fill="none">
  <path opacity="0.4" d="M1.1153 0.658264C0.770609 0.663328 0.495725 0.946531 0.500065 1.29122V2.07102C0.500065 2.07826 0.500065 2.08622 0.500065 2.09345V16.7079C0.49681 16.9332 0.615444 17.143 0.810034 17.2566C1.00462 17.3701 1.24551 17.3701 1.4401 17.2566C1.63469 17.143 1.75332 16.9332 1.75007 16.7079V11.3303C2.17143 11.1437 3.30895 10.6677 4.56257 10.6677C5.71708 10.6677 6.43901 11.021 7.29839 11.4377C8.15776 11.8544 9.15422 12.3343 10.5782 12.3343C12.4908 12.3343 15.0606 11.5043 15.0606 11.5043C15.3221 11.4232 15.5004 11.1809 15.5001 10.9071V2.09345C15.5004 1.89235 15.4039 1.70319 15.2407 1.58527C15.0773 1.46773 14.8675 1.43554 14.6765 1.49955C14.6765 1.49955 12.0868 2.33289 10.5782 2.33289C9.42368 2.33289 8.70319 1.97807 7.84382 1.5614C6.98444 1.14474 5.98654 0.666221 4.56257 0.666221C3.39286 0.666221 2.438 0.94219 1.74211 1.19212C1.69617 0.88215 1.42852 0.653924 1.1153 0.658264ZM4.56257 1.91622C5.71708 1.91622 6.43901 2.27104 7.29839 2.68771C8.15776 3.10437 9.15422 3.58289 10.5782 3.58289C11.9855 3.58289 13.4084 3.18684 14.2501 2.92859V10.4235C13.6659 10.5899 11.8767 11.0843 10.5782 11.0843C9.42368 11.0843 8.70319 10.7299 7.84382 10.3132C6.98444 9.89654 5.98654 9.41767 4.56257 9.41767C3.40335 9.41767 2.4503 9.70919 1.75007 9.97756V2.5282C2.1859 2.34953 3.30859 1.91622 4.56257 1.91622Z" fill="var(--color-emoji-header-icon)"/>
</svg>`,
    },
};
exports.BchatEmojiPanel = (0, react_1.forwardRef)((props, ref) => {
    const { onEmojiClicked, show, isModal = false } = props;
    const theme = (0, react_redux_1.useSelector)(theme_1.getTheme);
    const pickerRef = ref;
    (0, react_1.useEffect)(() => {
        let isCancelled = false;
        if (pickerRef.current && pickerRef.current.children.length === 0) {
            (0, i18n_1.loadEmojiPanelI18n)()
                .then(async (i18n) => {
                if (isCancelled) {
                    return;
                }
                new emoji_mart_1.Picker({
                    data: data_1.default,
                    ref,
                    i18n,
                    onEmojiSelect: onEmojiClicked,
                    ...pickerProps,
                    categoryIcons,
                });
            })
                .catch(lodash_1.noop);
        }
        return () => {
            isCancelled = true;
        };
    }, [data_1.default, pickerProps]);
    return (react_1.default.createElement(exports.StyledEmojiPanel, { isModal: isModal, theme: theme, className: (0, classnames_1.default)(show && 'show', 'emoji-panel'), ref: ref }));
});
