"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatLastSeenIndicator = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const conversations_1 = require("../../state/selectors/conversations");
const BchatMessagesListContainer_1 = require("./BchatMessagesListContainer");
const LastSeenBarContainer = styled_components_1.default.div `
  padding-bottom: 35px;
  max-width: 300px;
  align-self: center;
  padding-top: 28px;
  display: flex;
  flex-direction: row;
  align-items: center;
`;
const LastSeenBar = styled_components_1.default.div `
  height: 2px;
  background-color: var(--color-last-seen-indicator);
  flex-grow: 1;
  min-width: 60px;
  flex-shrink: 0;
`;
const LastSeenText = styled_components_1.default.div `
  margin-top: 3px;
  font-size: 11px;
  line-height: 26px;
  letter-spacing: 0.3px;
  text-transform: uppercase;
  text-align: center;
  flex-shrink: 0;
  margin-inline: 1rem;

  color: var(--color-last-seen-indicator);
`;
const BchatLastSeenIndicator = (props) => {
    const [didScroll, setDidScroll] = (0, react_1.useState)(false);
    const quotedMessageToAnimate = (0, react_redux_1.useSelector)(conversations_1.getQuotedMessageToAnimate);
    const scrollToLoadedMessage = (0, react_1.useContext)(BchatMessagesListContainer_1.ScrollToLoadedMessageContext);
    (0, react_1.useLayoutEffect)(() => {
        if (!quotedMessageToAnimate && !didScroll) {
            scrollToLoadedMessage(props.messageId, 'unread-indicator');
            setDidScroll(true);
        }
        else if (quotedMessageToAnimate) {
            setDidScroll(true);
        }
    });
    return (react_1.default.createElement(LastSeenBarContainer, { id: "unread-indicator" },
        react_1.default.createElement(LastSeenBar, null),
        react_1.default.createElement(LastSeenText, null, window.i18n('unreadMessages')),
        react_1.default.createElement(LastSeenBar, null)));
};
exports.BchatLastSeenIndicator = BchatLastSeenIndicator;
