"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatRightPanelWithDetails = void 0;
const react_1 = __importStar(require("react"));
const icon_1 = require("../icon");
const lodash_1 = __importDefault(require("lodash"));
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
const react_redux_1 = require("react-redux");
const data_1 = require("../../data/data");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const bchat_1 = require("../../bchat");
const conversations_1 = require("../../state/ducks/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const timerOptions_1 = require("../../state/selectors/timerOptions");
const Avatar_1 = require("../avatar/Avatar");
const Text_1 = require("../basic/Text");
const MediaGallery_1 = require("./media-gallery/MediaGallery");
const MessageAttachment_1 = require("../../types/MessageAttachment");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const Flex_1 = require("../basic/Flex");
const electron_1 = require("electron");
const Toast_1 = require("../../bchat/utils/Toast");
const conversations_3 = require("../../bchat/conversations");
const open_group_1 = require("../../bchat/group/open-group");
const closed_group_1 = require("../../bchat/group/closed-group");
const useSet_1 = require("../../hooks/useSet");
const utils_1 = require("../../bchat/utils");
const MemberListItem_1 = require("../MemberListItem");
const classnames_1 = __importDefault(require("classnames"));
const InviteContacts_1 = require("./InviteContacts");
const BchatButton_1 = require("../basic/BchatButton");
const BchatButton_2 = require("../basic/BchatButton");
const BchatButton_3 = require("../basic/BchatButton");
const Menu_1 = require("../menu/Menu");
const theme_1 = require("../../state/selectors/theme");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const types_1 = require("../../types");
async function getMediaGalleryProps(conversationId) {
    const rawMedia = await (0, data_1.getMessagesWithVisualMediaAttachments)(conversationId, bchat_1.Constants.CONVERSATION.DEFAULT_MEDIA_FETCH_COUNT);
    const rawDocuments = await (0, data_1.getMessagesWithFileAttachments)(conversationId, bchat_1.Constants.CONVERSATION.DEFAULT_DOCUMENTS_FETCH_COUNT);
    const media = lodash_1.default.flatten(rawMedia.map(attributes => {
        const { attachments, source, id, timestamp, serverTimestamp, received_at } = attributes;
        return (attachments || [])
            .filter((attachment) => attachment.thumbnail && !attachment.pending && !attachment.error)
            .map((attachment, index) => {
            const { thumbnail } = attachment;
            const mediaItem = {
                objectURL: (0, MessageAttachment_1.getAbsoluteAttachmentPath)(attachment.path),
                thumbnailObjectUrl: thumbnail ? (0, MessageAttachment_1.getAbsoluteAttachmentPath)(thumbnail.path) : undefined,
                contentType: attachment.contentType || '',
                index,
                messageTimestamp: timestamp || serverTimestamp || received_at || 0,
                messageSender: source,
                messageId: id,
                attachment,
            };
            return mediaItem;
        });
    }));
    const documents = rawDocuments.map(attributes => {
        if (!attributes.attachments?.length || types_1.MIME.isAudio(attributes.attachments[0]?.contentType)) {
            return null;
        }
        const attachment = attributes.attachments[0];
        const { source, id, timestamp, serverTimestamp, received_at } = attributes;
        return {
            contentType: attachment.contentType,
            index: 0,
            attachment,
            messageTimestamp: timestamp || serverTimestamp || received_at || 0,
            messageSender: source,
            messageId: id,
        };
    });
    return {
        media,
        documents: lodash_1.default.compact(documents),
    };
}
const MAX_USERNAME_LENGTH = 20;
const ProfileName = (props) => {
    const [profileName, setProfileName] = (0, react_1.useState)(props.grpName);
    const [errorDisplayed, setErrorDisplayed] = (0, react_1.useState)(false);
    const [errorMessage, setErrorMessage] = (0, react_1.useState)('placeholder');
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversation);
    if (!selectedConversation) {
        return null;
    }
    const convo = (0, conversations_3.getConversationController)().get(selectedConversation.id);
    const oldAvatarPath = convo.getAvatarPath();
    const newAvatarObjecturl = null;
    const onNameEdited = (0, react_1.useCallback)((event) => {
        setProfileName(event.target.value);
    }, []);
    function onClickOK() {
        const trimmedGroupName = profileName?.trim();
        if (!trimmedGroupName) {
            onShowError(window.i18n('emptyGroupNameError'));
            return;
        }
        if (trimmedGroupName !== convo.getName() || newAvatarObjecturl !== oldAvatarPath) {
            if (convo.isPublic()) {
                void (0, open_group_1.initiateOpenGroupUpdate)(convo.id, trimmedGroupName, {
                    objectUrl: newAvatarObjecturl,
                });
            }
            else {
                const members = convo.get('members') || [];
                void (0, closed_group_1.initiateClosedGroupUpdate)(convo.id, trimmedGroupName, members);
                setProfileName('');
            }
        }
        props.onCloseEdit();
    }
    function onShowError(msg) {
        if (errorDisplayed) {
            return;
        }
        setErrorDisplayed(true);
        setErrorMessage(msg);
        setTimeout(() => {
            setErrorDisplayed(false);
        }, 3000);
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { className: "profile-name" },
            react_1.default.createElement("div", { className: "inputBox" },
                react_1.default.createElement("input", { type: "text", className: "profile-name-input", value: profileName, placeholder: 'Enter a group name', onChange: onNameEdited, maxLength: MAX_USERNAME_LENGTH - 1, tabIndex: 0, required: true, "aria-required": true, "data-testid": "profile-name-input" })),
            react_1.default.createElement("div", { className: "saveIcon" },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "save_tick", iconSize: 16, onClick: () => onClickOK() }))),
        errorDisplayed ? (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(Text_1.SpacerXS, null),
            react_1.default.createElement("p", { style: { color: 'red' } }, errorMessage))) : null));
};
const HeaderItem = () => {
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversation);
    const dispatch = (0, react_redux_1.useDispatch)();
    if (!selectedConversation) {
        return null;
    }
    const { id, profileName, isBnsHolder, isGroup } = selectedConversation;
    return (react_1.default.createElement("div", { className: "group-settings-header" },
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: 'space-between', alignItems: "center", height: "70px", padding: "25px", className: "group-settings-header-title-wrapper" },
            react_1.default.createElement("span", { className: "group-settings-header-titleTxt" }, isGroup ? 'Group Info' : 'Profile Info'),
            react_1.default.createElement("span", { onClick: () => dispatch((0, conversations_1.closeRightPanel)()), className: "group-settings-header-closeBox" },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'xWithCircle', iconSize: 26, iconColor: "var(--color-text)" }))),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "group-settings-header-avatarBox" },
            react_1.default.createElement(Avatar_1.Avatar, { size: isGroup ? Avatar_1.AvatarSize.L : Avatar_1.AvatarSize.XL, pubkey: id, isBnsHolder: isBnsHolder }),
            react_1.default.createElement(Text_1.SpacerXS, null),
            react_1.default.createElement("p", null, profileName)),
        react_1.default.createElement(Text_1.SpacerLG, null)));
};
const ClassicMemberList = (props) => {
    const { onSelect, convoId, onUnselect, selectedMembers, removeMem } = props;
    const weAreAdmin = (0, useParamSelector_1.useWeAreAdmin)(convoId);
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(convoId);
    if (!convoProps) {
        throw new Error('MemberList needs convoProps');
    }
    let currentMembers = convoProps.members || [];
    const { groupAdmins } = convoProps;
    currentMembers = [...currentMembers].sort(m => (groupAdmins?.includes(m) ? -1 : 0));
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)(removeMem && 'remove-contact-list', !removeMem && 'group-member-list') }, currentMembers.map(member => {
            const isSelected = (weAreAdmin && selectedMembers.includes(member)) || false;
            const isAdmin = groupAdmins?.includes(member);
            return (react_1.default.createElement(MemberListItem_1.MemberListItem, { pubkey: member, onlyList: !removeMem, removeMem: removeMem, isSelected: isSelected, onSelect: onSelect, onUnselect: onUnselect, key: member, isAdmin: isAdmin }));
        }))));
};
const BchatRightPanelWithDetails = () => {
    const [documents, setDocuments] = (0, react_1.useState)([]);
    const [media, setMedia] = (0, react_1.useState)([]);
    const [fullView, setFullView] = (0, react_1.useState)(false);
    const [edit, setEdit] = (0, react_1.useState)(false);
    const [removeMem, setRemoveMem] = (0, react_1.useState)(false);
    const [addMem, setAddMem] = (0, react_1.useState)(false);
    const [expanded, setExpanded] = (0, react_1.useState)(false);
    const dispatch = (0, react_redux_1.useDispatch)();
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversation);
    const isShowing = (0, react_redux_1.useSelector)(conversations_2.isRightPanelShowing);
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(selectedConversation?.id);
    const existingMembers = convoProps?.members || [];
    const ref = (0, react_1.useRef)(null);
    const rightPanelref = (0, react_1.useRef)(null);
    const { addTo, removeFrom, uniqueValues: membersToKeepWithUpdate } = (0, useSet_1.useSet)(existingMembers);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    (0, react_1.useEffect)(() => {
        let isRunning = true;
        if (isShowing && selectedConversation) {
            void getMediaGalleryProps(selectedConversation.id).then(results => {
                if (isRunning) {
                    if (!lodash_1.default.isEqual(documents, results.documents)) {
                        setDocuments(results.documents);
                    }
                    if (!lodash_1.default.isEqual(media, results.media)) {
                        setMedia(results.media);
                    }
                }
            });
        }
        return () => {
            isRunning = false;
            return;
        };
    }, [isShowing, selectedConversation?.id]);
    (0, useInterval_1.default)(async () => {
        if (isShowing && selectedConversation) {
            const results = await getMediaGalleryProps(selectedConversation.id);
            if (results.documents.length !== documents.length || results.media.length !== media.length) {
                setDocuments(results.documents);
                setMedia(results.media);
            }
        }
    }, 10000);
    if (!selectedConversation) {
        return null;
    }
    const { id, subscriberCount, name, isKickedFromGroup, left, isPublic, weAreAdmin, isBlocked, isGroup, isPrivate, } = selectedConversation;
    const username = String((0, useParamSelector_1.useConversationUsername)(id));
    const showMemberCount = !!(subscriberCount && subscriberCount > 0);
    const commonNoShow = isKickedFromGroup || left || isBlocked;
    const hasDisappearingMessages = !isPublic && !commonNoShow;
    const leaveGroupString = isPublic
        ? window.i18n('deleteMessages')
        : isKickedFromGroup
            ? window.i18n('youGotKickedFromGroup')
            : left
                ? window.i18n('youLeftTheGroup')
                : window.i18n('leaveGroup');
    const timerOptions = (0, react_redux_1.useSelector)(timerOptions_1.getTimerOptions).timerOptions;
    const disappearingMessagesOptions = timerOptions.map(option => {
        return {
            content: option.name,
            onClick: () => {
                void (0, conversationInteractions_1.setDisappearingMessagesByConvoId)(id, option.value);
            },
        };
    });
    const showUpdateGroupNameButton = isGroup && (!isPublic || (isPublic && weAreAdmin)) && !commonNoShow;
    const showAddRemoveModeratorsButton = weAreAdmin && !commonNoShow && isPublic;
    const showUpdateGroupMembersButton = !isPublic && isGroup && !commonNoShow;
    const deleteConvoAction = isPublic
        ? () => {
            (0, conversationInteractions_1.deleteAllMessagesByConvoIdWithConfirmation)(id);
        }
        : left
            ? () => {
                (0, conversationInteractions_1.deleteGroupByConvoId)(id, username);
            }
            : () => {
                (0, conversationInteractions_1.showLeaveGroupByConvoId)(id, username, react_1.default.createElement(icon_1.BchatIcon, { iconType: "leaveGroup", iconColor: "#FF3E3E", iconSize: 30 }));
            };
    const handleCopy = () => {
        electron_1.clipboard.writeText(id, 'clipboard');
        (0, Toast_1.pushUserCopySuccess)();
    };
    const dispalyMedia = (value) => {
        setFullView(value);
    };
    const onAdd = (member) => {
        if (!weAreAdmin) {
            utils_1.ToastUtils.pushOnlyAdminCanRemove();
            return;
        }
        addTo(member);
    };
    const onRemove = (member) => {
        if (!weAreAdmin) {
            window?.log?.warn('Only group admin can remove members!');
            utils_1.ToastUtils.pushOnlyAdminCanRemove();
            return;
        }
        if (convoProps?.groupAdmins?.includes(member)) {
            utils_1.ToastUtils.pushCannotRemoveCreatorFromGroup();
            window?.log?.warn(`User ${member} cannot be removed as they are the creator of the closed group.`);
            return;
        }
        removeFrom(member);
    };
    async function onSubmit(convoId, membersAfterUpdate) {
        const convoProps = (0, conversations_3.getConversationController)()
            .get(convoId)
            .getConversationModelProps();
        if (!convoProps || !convoProps.isGroup || convoProps.isPublic) {
            throw new Error('Invalid convo for updateGroupMembersDialog');
        }
        if (!convoProps.weAreAdmin) {
            window.log.warn('Skipping update of members, we are not the admin');
            return;
        }
        const ourPK = utils_1.UserUtils.getOurPubKeyStrFromCache();
        const allMembersAfterUpdate = lodash_1.default.uniq(lodash_1.default.concat(membersAfterUpdate, [ourPK]));
        const existingMembers = convoProps.members || [];
        const existingZombies = convoProps.zombies || [];
        const allExistingMembersWithZombies = lodash_1.default.uniq(existingMembers.concat(existingZombies));
        const notPresentInOld = allMembersAfterUpdate.filter(m => !allExistingMembersWithZombies.includes(m));
        const membersToRemove = allExistingMembersWithZombies.filter(m => !allMembersAfterUpdate.includes(m));
        const xor = lodash_1.default.xor(membersToRemove, notPresentInOld);
        if (xor.length === 0) {
            window.log.info('skipping group update: no detected changes in group member list');
            return;
        }
        const filteredMembers = allMembersAfterUpdate.filter(memberAfterUpdate => !lodash_1.default.includes(membersToRemove, memberAfterUpdate));
        void (0, closed_group_1.initiateClosedGroupUpdate)(convoId, convoProps.name || 'Unknown', filteredMembers);
    }
    const onClickOK = async () => {
        if (removeMem) {
            dispatch((0, modalDialog_1.updateConfirmModal)({
                title: 'Remove Users?',
                message: 'Are you sure you want to remove these users from this group?',
                okText: 'Remove',
                iconShow: true,
                customIcon: (react_1.default.createElement(icon_1.BchatIcon, { iconType: "avatarX", iconSize: 24, clipRule: "evenodd", fillRule: "evenodd" })),
                okTheme: BchatButton_3.BchatButtonColor.Danger,
                onClickOk: async () => {
                    await onSubmit(id, membersToKeepWithUpdate);
                    setRemoveMem(false);
                },
                onClickClose: () => {
                    dispatch((0, modalDialog_1.updateConfirmModal)(null));
                },
            }));
        }
        if (addMem) {
            await ref.current?.onclick();
            setAddMem(false);
        }
    };
    return (react_1.default.createElement("div", { ref: rightPanelref, className: "group-settings" }, !fullView ? (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(HeaderItem, null),
        isPrivate && (react_1.default.createElement("div", { className: "group-settings-header-chatIdBox" },
            react_1.default.createElement("p", null, "BChat ID"),
            react_1.default.createElement(Text_1.SpacerXS, null),
            react_1.default.createElement("div", { className: "id-wrapper" },
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "flex-start" },
                    react_1.default.createElement("span", { className: "txt" }, id),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'copy', iconSize: 0, fillRule: "evenodd", clipRule: "evenodd", onClick: handleCopy }))))),
        !edit ? (react_1.default.createElement("div", { className: "group-settings-nameEditBox" },
            react_1.default.createElement("h2", { "data-testid": "right-panel-group-name" }, name),
            showUpdateGroupNameButton && (react_1.default.createElement("div", null,
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "pencil", iconSize: "medium", iconColor: "#128b17", onClick: () => {
                        setEdit(true);
                    }, dataTestId: "edit-profile-icon" }))))) : (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(ProfileName, { onCloseEdit: () => setEdit(false), grpName: name }))),
        hasDisappearingMessages && (react_1.default.createElement("div", { style: { width: '100%' } },
            react_1.default.createElement("div", { className: "disppear-wrapper", role: "button", onClick: () => setExpanded(!expanded) },
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center" },
                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'chatTimer', iconSize: 17, fillRule: "evenodd", clipRule: "evenodd" }),
                    react_1.default.createElement(Menu_1.MenuWrapper, { style: { fontSize: '16px', fontWeight: 300 } }, window.i18n('disappearingMessages'))),
                react_1.default.createElement(icon_1.BchatIcon, { iconType: "chevron", iconSize: "small", iconRotation: expanded ? 0 : 268 })),
            expanded && (react_1.default.createElement("div", { className: "disappear-option" }, disappearingMessagesOptions.map((item, key) => {
                return (react_1.default.createElement("span", { key: key, onClick: () => {
                        setExpanded(false);
                        item.onClick();
                    } }, item.content));
            }))))),
        showMemberCount && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { role: "button", className: "subtle", style: { textAlign: 'center' } }, window.i18n('members', [`${subscriberCount}`])))),
        showAddRemoveModeratorsButton && (react_1.default.createElement("div", { className: "group-settings-header-moderator-wholeBox" },
            react_1.default.createElement("div", { className: "group-settings-header-moderator-txtBox" }, "Moderators"),
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", justifyContent: "center", margin: "" },
                react_1.default.createElement("div", { className: "addButton", role: "button", onClick: () => {
                        (0, conversationInteractions_1.showAddModeratorsByConvoId)(id);
                    } },
                    react_1.default.createElement("span", { style: { marginRight: '5px' } },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: 'addModerator', fillRule: 'evenodd', clipRule: 'evenodd', iconSize: 20, iconColor: '#F0F0F0' })),
                    react_1.default.createElement("span", { style: { color: '#F0F0F0' } }, window.i18n('add'))),
                react_1.default.createElement("div", { className: "removeButton", role: "button", onClick: () => {
                        (0, conversationInteractions_1.showRemoveModeratorsByConvoId)(id);
                    } },
                    react_1.default.createElement("span", { style: { marginRight: '5px' } },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: 'removeFromModerators', fillRule: 'evenodd', clipRule: 'evenodd', iconSize: 20, iconColor: "#FF3E3E" })),
                    'Remove')))),
        showUpdateGroupMembersButton && (react_1.default.createElement("div", { className: "grp_btn_wrapper" },
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", alignItems: "center" },
                react_1.default.createElement("div", { className: "group-settings-item" },
                    react_1.default.createElement("div", { className: "invite-friends-container", style: { marginRight: '10px' } }),
                    window.i18n('groupMembers')),
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row" }, removeMem || addMem ? (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: "xWithCircle", iconSize: 20, onClick: () => {
                            setRemoveMem(false);
                            setAddMem(false);
                        } }),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: "circleFillTick", iconSize: 20, iconColor: "#108D32", onClick: () => onClickOK() }))) : (react_1.default.createElement(react_1.default.Fragment, null,
                    weAreAdmin && (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "avatarX", iconSize: 26, clipRule: "evenodd", fillRule: "evenodd", onClick: () => setRemoveMem(true) })),
                    react_1.default.createElement("div", { className: "add-btn", role: "button", style: { marginLeft: '5px' }, onClick: () => {
                            setAddMem(true);
                        } },
                        react_1.default.createElement("div", { className: "invite-friends-container", style: { marginRight: '10px' }, onClick: () => {
                                if (selectedConversation) {
                                    (0, conversationInteractions_1.showInviteContactByConvoId)(selectedConversation.id);
                                }
                            } }),
                        "Add +"))))),
            react_1.default.createElement("div", { className: "list-wrapper" }, addMem ? (react_1.default.createElement(InviteContacts_1.InviteContact, { conversationId: selectedConversation.id, ref: ref })) : (react_1.default.createElement(ClassicMemberList, { removeMem: removeMem, convoId: selectedConversation.id, onSelect: onAdd, onUnselect: onRemove, selectedMembers: membersToKeepWithUpdate }))))),
        isGroup && (react_1.default.createElement("div", { style: { width: '90%', borderRadius: '12px' }, onClick: deleteConvoAction },
            react_1.default.createElement(BchatButton_1.BchatButton, { text: leaveGroupString, iconType: isPublic ? 'delete' : 'leaveGroup', iconSize: 20, buttonType: BchatButton_2.BchatButtonType.Medium, buttonColor: BchatButton_3.BchatButtonColor.Danger }))),
        react_1.default.createElement(Text_1.SpacerMD, null),
        react_1.default.createElement("div", { className: "hr-line" }),
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", width: "100%" },
            react_1.default.createElement("span", { className: "group-settings-media-txt" }, "Media, docs"),
            react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'chevron', iconSize: 14, iconRotation: 268, iconColor: "#A7A7BA", onClick: () => dispalyMedia(true) })),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('img-wrapper', existingMembers.length >= 3 && 'grp_more_member') },
            react_1.default.createElement(MediaGallery_1.MediaGallery, { documents: documents, media: media, fullView: fullView })),
        react_1.default.createElement(Text_1.SpacerMD, null))) : (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center", height: "70px", width: "100%", style: { borderRadius: '16px', background: 'var(--color-profile-header-bg)' } },
            react_1.default.createElement("span", { onClick: () => dispalyMedia(false), className: "group-settings-header-closeBox", style: { marginRight: '10px' } },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'KeyboardBackspaceArrow', iconSize: 28, iconColor: darkMode ? '#A9AEBA' : '#3E4A53' })),
            react_1.default.createElement("span", { className: "group-settings-header-titleTxt" }, "Media & Documents")),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement(MediaGallery_1.MediaGallery, { documents: documents, media: media, fullView: true })))));
};
exports.BchatRightPanelWithDetails = BchatRightPanelWithDetails;
