"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatStagedLinkPreview = exports.getPreview = exports.LINK_PREVIEW_TIMEOUT = void 0;
const react_1 = __importDefault(require("react"));
const node_fetch_1 = __importDefault(require("node-fetch"));
const Attachment_1 = require("../../types/Attachment");
const util_1 = require("../../util");
const linkPreviewFetch_1 = require("../../util/linkPreviewFetch");
const StagedLinkPreview_1 = require("./StagedLinkPreview");
const VisualAttachment_1 = require("../../types/attachments/VisualAttachment");
const linkPreviews_1 = require("../../util/linkPreviews");
exports.LINK_PREVIEW_TIMEOUT = 20 * 1000;
const getPreview = async (url, abortSignal) => {
    if (!linkPreviews_1.LinkPreviews.isLinkSafeToPreview(url)) {
        throw new Error('Link not safe for preview');
    }
    window?.log?.info('insecureNodeFetch => plaintext for getPreview()');
    const linkPreviewMetadata = await util_1.LinkPreviewUtil.fetchLinkPreviewMetadata(node_fetch_1.default, url, abortSignal);
    if (!linkPreviewMetadata) {
        throw new Error('Could not fetch link preview metadata');
    }
    const { title, imageHref, date } = linkPreviewMetadata;
    let image;
    if (imageHref && linkPreviews_1.LinkPreviews.isLinkSafeToPreview(imageHref)) {
        let objectUrl;
        try {
            window?.log?.info('insecureNodeFetch => plaintext for getPreview()');
            const fullSizeImage = await (0, linkPreviewFetch_1.fetchLinkPreviewImage)(node_fetch_1.default, imageHref, abortSignal);
            if (!fullSizeImage) {
                throw new Error('Failed to fetch link preview image');
            }
            const withBlob = await util_1.AttachmentUtil.autoScaleForThumbnail({
                contentType: fullSizeImage.contentType,
                blob: new Blob([fullSizeImage.data], {
                    type: fullSizeImage.contentType,
                }),
            });
            const data = await (0, Attachment_1.arrayBufferFromFile)(withBlob.blob);
            objectUrl = URL.createObjectURL(withBlob.blob);
            const dimensions = await (0, VisualAttachment_1.getImageDimensions)({
                objectUrl,
            });
            image = {
                data,
                size: data.byteLength,
                ...dimensions,
                contentType: withBlob.blob.type,
            };
        }
        catch (error) {
            window?.log?.error('getPreview failed to get image for link preview:', error.message);
        }
        finally {
            if (objectUrl) {
                URL.revokeObjectURL(objectUrl);
            }
        }
    }
    return {
        title,
        url,
        image,
        date,
    };
};
exports.getPreview = getPreview;
const BchatStagedLinkPreview = (props) => {
    if (!props.url) {
        return null;
    }
    return (react_1.default.createElement(StagedLinkPreview_1.StagedLinkPreview, { onClose: props.onClose, isLoaded: props.isLoaded, title: props.title, domain: props.domain, url: props.url, image: props.image }));
};
exports.BchatStagedLinkPreview = BchatStagedLinkPreview;
