"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatViewContactPanel = void 0;
const react_1 = __importDefault(require("react"));
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const classnames_1 = __importDefault(require("classnames"));
const conversations_1 = require("../../state/ducks/conversations");
const ContactBubbleChatIcon_1 = __importDefault(require("../icon/ContactBubbleChatIcon"));
const Avatar_1 = require("../avatar/Avatar");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatButton_1 = require("../basic/BchatButton");
const conversations_2 = require("../../bchat/conversations");
const conversation_1 = require("../../models/conversation");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const BchatViewContactPanel = (props) => {
    const { isIncoming, names, addresses } = props;
    const iconColor = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark' ? 'white' : '#C5C5C5';
    const dispatch = (0, react_redux_1.useDispatch)();
    const openConverstation = async (pubKey) => {
        await (0, conversations_2.getConversationController)().getOrCreateAndWait(pubKey, conversation_1.ConversationTypeEnum.PRIVATE);
        await (0, conversations_1.openConversationWithMessages)({ conversationKey: pubKey, messageId: null });
    };
    const openConfirmModal = (pubKey) => {
        if (!isIncoming) {
            openConverstation(pubKey);
            return;
        }
        dispatch((0, modalDialog_1.updateConfirmModal)({
            bchatIcon: 'avatar',
            iconSize: 31,
            iconShow: true,
            title: 'Start chat now?',
            message: 'Do you want to chat with this contact now?',
            onClickClose: () => dispatch((0, modalDialog_1.updateConfirmModal)(null)),
            onClickOk: () => openConverstation(pubKey),
            okText: 'Start Chatting',
            okTheme: BchatButton_1.BchatButtonColor.Primary,
        }));
    };
    return (react_1.default.createElement("div", { className: "contact-list" },
        react_1.default.createElement("div", { className: "contact-list-header" },
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: 'space-between', alignItems: "center", height: "70px", padding: "25px", className: "contact-list-header-title-wrapper" },
                react_1.default.createElement("span", { className: "contact-list-header-titleTxt" }, "View Contacts"),
                react_1.default.createElement("span", { onClick: () => {
                        window.inboxStore?.dispatch((0, conversations_1.updateViewContactPanel)(null));
                    }, className: "contact-list-header-closeBox" },
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'xWithCircle', iconSize: 26, iconColor: "var(--color-text)" })))),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: 'contact-list-inner-wrapper', style: { padding: '0px' } }, (addresses ?? []).map((pubkey, index) => (react_1.default.createElement(ContactList, { key: index, pubkey: pubkey, userName: names?.[index] ?? '', iconColor: iconColor, openConfirmModal: openConfirmModal }))))));
};
exports.BchatViewContactPanel = BchatViewContactPanel;
const ContactList = (props) => {
    const { pubkey, userName, iconColor, openConfirmModal } = props;
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(pubkey);
    const validUserName = userName.length >= 65 ? userName.slice(0, 8) + '.....' + userName.slice(-8) : userName;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`address-content-box `), style: { paddingLeft: '10px', paddingRight: '10px', marginLeft: '10px', marginRight: '10px' } },
            react_1.default.createElement("div", { className: "avatarBox" },
                react_1.default.createElement(Avatar_1.Avatar, { pubkey: pubkey, size: Avatar_1.AvatarSize.M, isBnsHolder: isBnsHolder })),
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", margin: "0 15px" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement("span", { className: (0, classnames_1.default)('username') }, validUserName)),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement("div", { className: 'address' }, pubkey)),
            react_1.default.createElement("div", { style: { cursor: 'pointer' }, onClick: () => openConfirmModal(pubkey) },
                react_1.default.createElement(ContactBubbleChatIcon_1.default, { color: iconColor }))),
        react_1.default.createElement(Text_1.SpacerXS, null)));
};
