"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactName = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const Emojify_1 = require("./Emojify");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const ContactName = (props) => {
    const { pubkey, name, profileName, module, compact, shouldShowPubkey } = props;
    const prefix = module ? module : 'module-contact-name';
    const convoName = (0, useParamSelector_1.useConversationUsernameOrShorten)(pubkey);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(pubkey);
    const shouldShowProfile = Boolean(convoName || profileName || name);
    const textProfile = profileName || name || convoName || window.i18n('anonymous');
    return (react_1.default.createElement("span", { className: (0, classnames_1.default)(prefix, compact && 'compact'), dir: "auto", "data-testid": `${prefix}__profile-name` },
        shouldShowProfile ? (react_1.default.createElement("span", { className: `${prefix}__profile-name` },
            react_1.default.createElement(Emojify_1.Emojify, { text: textProfile, sizeClass: "small", isGroup: !isPrivate }))) : null,
        shouldShowProfile ? ' ' : null,
        shouldShowPubkey ? react_1.default.createElement("span", { className: `${prefix}__profile-number` }, pubkey) : null));
};
exports.ContactName = ContactName;
