"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationMessageRequestButtons = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const data_1 = require("../../data/data");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const messageType_1 = require("../../models/messageType");
const conversations_1 = require("../../bchat/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const BchatButton_1 = require("../basic/BchatButton");
const section_1 = require("../../state/ducks/section");
const DeclineMessageRequest_1 = __importDefault(require("../icon/DeclineMessageRequest"));
const ConversationMessageRequestButtons = () => {
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversation);
    const [hasIncoming, setHasIncomingMsgs] = (0, react_1.useState)(false);
    const [incomingChecked, setIncomingChecked] = (0, react_1.useState)(false);
    const dispatch = (0, react_redux_1.useDispatch)();
    (0, react_1.useEffect)(() => {
        async function getIncomingMessages() {
            const id = selectedConversation?.id;
            if (id) {
                const msgCount = await (0, data_1.getMessageCountByType)(selectedConversation?.id, messageType_1.MessageDirection.incoming);
                if (msgCount > 0) {
                    setHasIncomingMsgs(true);
                }
                else {
                    setHasIncomingMsgs(false);
                }
                setIncomingChecked(true);
            }
        }
        getIncomingMessages();
    }, []);
    if (!selectedConversation || !hasIncoming || !incomingChecked) {
        return null;
    }
    const convoModel = (0, conversations_1.getConversationController)().get(selectedConversation.id);
    const showMsgRequestUI = convoModel && convoModel.isIncomingRequest();
    const handleDeclineConversationRequest = () => {
        const customIcon = react_1.default.createElement(DeclineMessageRequest_1.default, { iconSize: 30 });
        (0, conversationInteractions_1.declineConversationWithConfirm)(selectedConversation.id, true, customIcon);
    };
    const handleAcceptConversationRequest = async () => {
        const { id } = selectedConversation;
        const convo = (0, conversations_1.getConversationController)().get(selectedConversation.id);
        await convo.setDidApproveMe(true);
        await convo.addOutgoingApprovalMessage(Date.now());
        dispatch((0, section_1.setOverlayMode)(undefined));
        await (0, conversationInteractions_1.approveConvoAndSendResponse)(id, true);
    };
    if (!showMsgRequestUI) {
        return null;
    }
    return (react_1.default.createElement(ConversationRequestBanner, null,
        "Allow this person to chat with you?",
        react_1.default.createElement(ConversationBannerRow, null,
            react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: BchatButton_1.BchatButtonColor.Danger, buttonType: BchatButton_1.BchatButtonType.Default, text: window.i18n('decline'), onClick: handleDeclineConversationRequest, dataTestId: "decline-message-request" }),
            react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: BchatButton_1.BchatButtonColor.Green, buttonType: BchatButton_1.BchatButtonType.Default, onClick: handleAcceptConversationRequest, text: window.i18n('accept'), dataTestId: "accept-message-request" }))));
};
exports.ConversationMessageRequestButtons = ConversationMessageRequestButtons;
const ConversationBannerRow = styled_components_1.default.div `
  display: flex;
  flex-direction: row;
  gap: var(--margins-lg);
  justify-content: center;
`;
const ConversationRequestBanner = styled_components_1.default.div `
  display: flex;
  flex-direction: column;
  justify-content: center;
  padding: var(--margins-lg);
  gap: var(--margins-lg);
  font-size: 22px;
  background: var(--color-MsgReqModal-bg);
  text-align: center;
  font-family: 'poppin-semibold';

`;
