"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationRequestinfo = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const data_1 = require("../../data/data");
const messageType_1 = require("../../models/messageType");
const conversations_1 = require("../../bchat/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const ConversationRequestinfo = () => {
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversation);
    const convoModel = selectedConversation && (0, conversations_1.getConversationController)().get(selectedConversation.id);
    const showMsgRequestUI = selectedConversation && convoModel && convoModel.isIncomingRequest();
    const [hasIncomingMessages, setHasIncomingMessages] = (0, react_1.useState)(false);
    const [incomingChecked, setIncomingChecked] = (0, react_1.useState)(false);
    (0, react_1.useEffect)(() => {
        async function getIncomingMessages() {
            const id = selectedConversation?.id;
            if (id) {
                const msgCount = await (0, data_1.getMessageCountByType)(selectedConversation?.id, messageType_1.MessageDirection.incoming);
                if (msgCount > 0) {
                    setHasIncomingMessages(true);
                }
                else {
                    setHasIncomingMessages(false);
                }
                setIncomingChecked(true);
            }
        }
        getIncomingMessages();
    }, [selectedConversation]);
    if (!showMsgRequestUI || !hasIncomingMessages || !incomingChecked) {
        return null;
    }
    return (react_1.default.createElement(ConversationRequestTextBottom, null,
        react_1.default.createElement(ConversationRequestTextInner, null, window.i18n('respondingToRequestWarning'))));
};
exports.ConversationRequestinfo = ConversationRequestinfo;
const ConversationRequestTextBottom = styled_components_1.default.div `
  display: flex;
  flex-direction: row;
  justify-content: center;
  padding: var(--margins-lg);
`;
const ConversationRequestTextInner = styled_components_1.default.div `
  color: var(--color-text-subtle);
  text-align: center;
  max-width: 390px;
`;
