"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InviteContact = void 0;
const react_1 = __importStar(require("react"));
const conversations_1 = require("../../bchat/conversations");
const utils_1 = require("../../bchat/utils");
const conversation_1 = require("../../models/conversation");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const lodash_1 = __importDefault(require("lodash"));
const constants_1 = require("../../bchat/constants");
const Text_1 = require("../basic/Text");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const MemberListItem_1 = require("../MemberListItem");
const conversations_2 = require("../../state/selectors/conversations");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const useSet_1 = require("../../hooks/useSet");
const closed_group_1 = require("../../bchat/group/closed-group");
const submitForOpenGroup = async (conversationId, pubkeys) => {
    const completeUrl = await (0, conversationInteractions_1.getCompleteUrlForV2ConvoId)(conversationId);
    const convo = (0, conversations_1.getConversationController)().get(conversationId);
    if (!convo || !convo.isPublic()) {
        throw new Error('submitForOpenGroup group not found');
    }
    const groupInvitation = {
        url: completeUrl,
        name: convo.getName() || 'Unknown',
    };
    pubkeys.forEach(async (pubkeyStr) => {
        const privateConvo = await (0, conversations_1.getConversationController)().getOrCreateAndWait(pubkeyStr, conversation_1.ConversationTypeEnum.PRIVATE);
        if (privateConvo) {
            void privateConvo.sendMessage({
                body: '',
                attachments: undefined,
                groupInvitation,
                preview: undefined,
                quote: undefined,
            });
        }
    });
};
const submitForClosedGroup = async (convoId, pubkeys) => {
    const convo = (0, conversations_1.getConversationController)().get(convoId);
    if (!convo || !convo.isGroup()) {
        throw new Error('submitForClosedGroup group not found');
    }
    const ourPK = utils_1.UserUtils.getOurPubKeyStrFromCache();
    let existingMembers = convo.get('members') || [];
    if (!Array.isArray(existingMembers)) {
        existingMembers = [];
    }
    existingMembers = lodash_1.default.compact(existingMembers);
    const existingZombies = convo.get('zombies') || [];
    const newMembers = pubkeys.filter(d => !existingMembers.includes(d));
    if (newMembers.length > 0) {
        if (newMembers.length + existingMembers.length + existingZombies.length >
            constants_1.VALIDATION.CLOSED_GROUP_SIZE_LIMIT) {
            utils_1.ToastUtils.pushTooManyMembers();
            return;
        }
        const allMembers = lodash_1.default.concat(existingMembers, newMembers, [ourPK]);
        const uniqMembers = lodash_1.default.uniq(allMembers);
        const groupId = convo.get('id');
        const groupName = convo.get('name');
        await (0, closed_group_1.initiateClosedGroupUpdate)(groupId, groupName || window.i18n('unknown'), uniqMembers);
    }
};
const InviteContactsInner = (0, react_1.forwardRef)((props, ref) => {
    const { conversationId } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const privateContactPubkeys = (0, react_redux_1.useSelector)(conversations_2.getPrivateContactsPubkeys);
    let validContactsForInvite = lodash_1.default.clone(privateContactPubkeys);
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(conversationId);
    const { uniqueValues: selectedContacts, addTo, removeFrom } = (0, useSet_1.useSet)();
    if (!convoProps) {
        throw new Error('InviteContactsDialogInner not a valid convoId given');
    }
    if (!convoProps.isGroup) {
        throw new Error('InviteContactsDialogInner must be a group');
    }
    if (!convoProps.isPublic) {
        const members = convoProps.members || [];
        const zombies = convoProps.zombies || [];
        validContactsForInvite = validContactsForInvite.filter(d => !members.includes(d) && !zombies.includes(d));
    }
    const isPublicConvo = convoProps.isPublic;
    const closeDialog = () => {
        dispatch((0, modalDialog_1.updateInviteContactModal)(null));
    };
    (0, react_1.useImperativeHandle)(ref, () => ({
        onclick: () => {
            onClickOK();
        },
    }));
    const onClickOK = () => {
        if (selectedContacts.length > 0) {
            if (isPublicConvo) {
                void submitForOpenGroup(conversationId, selectedContacts);
            }
            else {
                void submitForClosedGroup(conversationId, selectedContacts);
            }
        }
        closeDialog();
    };
    (0, useKey_1.default)((event) => {
        return event.key === 'Enter';
    }, onClickOK);
    (0, useKey_1.default)((event) => {
        return event.key === 'Esc' || event.key === 'Escape';
    }, closeDialog);
    const hasContacts = validContactsForInvite.length > 0;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "contact-selection-list" }, hasContacts ? (validContactsForInvite.map((member) => (react_1.default.createElement(MemberListItem_1.MemberListItem, { key: member, pubkey: member, isSelected: selectedContacts.includes(member), onSelect: addTo, onUnselect: removeFrom })))) : (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("p", { className: "no-contacts" }, window.i18n('noContactsToAdd')),
            react_1.default.createElement(Text_1.SpacerLG, null)))),
        react_1.default.createElement(Text_1.SpacerLG, null)));
});
exports.InviteContact = InviteContactsInner;
