"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypingBubble = void 0;
const react_1 = __importDefault(require("react"));
const TypingAnimation_1 = require("./TypingAnimation");
const styled_components_1 = __importDefault(require("styled-components"));
const conversation_1 = require("../../models/conversation");
const TypingBubbleContainer = styled_components_1.default.div `
  height: ${props => (props.isTyping ? 'auto' : '0px')};
  display: flow-root;
  padding-bottom: ${props => (props.isTyping ? '4px' : '0px')};
  padding-top: ${props => (props.isTyping ? '4px' : '0px')};
  transition: var(--default-duration);
  padding-inline-end: 16px;
  // padding-inline-start: 4px;
  overflow: hidden;
  flex-shrink: 0;
`;
const TypingBubble = (props) => {
    if (props.conversationType === conversation_1.ConversationTypeEnum.GROUP) {
        return null;
    }
    if (!props.isTyping) {
        return null;
    }
    return (react_1.default.createElement(TypingBubbleContainer, { ...props },
        react_1.default.createElement(TypingAnimation_1.TypingAnimation, null)));
};
exports.TypingBubble = TypingBubble;
