"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const useEncryptedFileFetch_1 = require("../../hooks/useEncryptedFileFetch");
const useAudioPeaks_1 = require("../../hooks/useAudioPeaks");
const react_redux_1 = require("react-redux");
const userConfig_1 = require("../../state/selectors/userConfig");
const theme_1 = require("../../state/selectors/theme");
const conversations_1 = require("../../state/selectors/conversations");
const conversations_2 = require("../../state/ducks/conversations");
const Attachment_1 = require("../../types/Attachment");
const AudioPlayerContext_1 = require("../basic/AudioPlayerContext");
const WaveformBar_1 = __importDefault(require("./WaveformBar"));
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const classnames_1 = __importDefault(require("classnames"));
const lodash_1 = require("lodash");
const WaveFormAudioPlayerWithEncryptedFile = ({ src, contentType, direction, size, messageId, }) => {
    const slicedSrc = src.slice(-64);
    const { urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(src, contentType, false);
    const { peaks, duration } = (0, useAudioPeaks_1.useAudioPeaks)(urlToLoad, Math.floor(300 / 4), slicedSrc, size);
    const dispatch = (0, react_redux_1.useDispatch)();
    const messageProps = (0, react_redux_1.useSelector)(conversations_1.getSortedMessagesOfSelectedConversation);
    const nextMessageToPlayId = (0, react_redux_1.useSelector)(conversations_1.getNextMessageToPlayId);
    const isCurrentlyRecording = (0, react_redux_1.useSelector)(userConfig_1.getIsCurrentlyRecording);
    const autoPlaySetting = (0, react_redux_1.useSelector)(userConfig_1.getAudioAutoplay);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const { currentPlayingId, playAudio, pauseAudio, seekTo, audioRef, handleAudioEnded } = (0, AudioPlayerContext_1.useAudioPlayer)();
    const isSameMessage = messageId == currentPlayingId;
    const [isPlaying, setIsPlaying] = (0, react_1.useState)(isSameMessage ? !audioRef.current?.audio?.current.paused : false);
    const [playbackSpeed, setPlaybackSpeed] = (0, react_1.useState)(1);
    const [remainingTime, setRemainingTime] = (0, react_1.useState)('00:00');
    const [progressTime, setProgressTime] = (0, react_1.useState)(audioRef.current?.audio?.current.currentTime);
    const isDraggingRef = (0, react_1.useRef)(false);
    const waveColor = direction === 'incoming' ? (darkMode ? '#16191F' : '#ACACAC') : '#1C581C';
    const progressColor = direction === 'incoming' ? '#2F8FFF' : '#C0FFC9';
    const beepRef = (0, react_1.useRef)(null);
    const isManualTriggerForPause = (0, react_1.useRef)(false);
    const audioContextDuration = isSameMessage ? audioRef.current?.audio?.current.duration : duration;
    const convertMsToSec = (0, react_1.useCallback)((duration, currentTime) => {
        let remaining = duration === currentTime ? duration : duration - currentTime;
        if (remaining < 0)
            remaining = 0;
        const minutes = Math.floor(remaining / 60);
        const seconds = Math.floor(remaining % 60);
        return `${minutes}:${seconds.toString().padStart(2, '0')}`;
    }, []);
    (0, react_1.useEffect)(() => {
        setRemainingTime(convertMsToSec(duration, 0));
    }, [peaks, duration, convertMsToSec]);
    (0, react_1.useEffect)(() => {
        if (messageId === nextMessageToPlayId) {
            handlePlayPause();
        }
    }, [nextMessageToPlayId]);
    (0, react_1.useEffect)(() => {
        const audio = audioRef.current?.audio?.current;
        if (!audio || !isSameMessage)
            return;
        const handlePlay = () => {
            if (audio) {
                audio.playbackRate = playbackSpeed;
            }
        };
        const handlePause = () => {
            if (audio.ended)
                return;
            if (!isManualTriggerForPause.current) {
                handleEnded();
            }
            isManualTriggerForPause.current = false;
            setIsPlaying(false);
        };
        const handleEnded = () => {
            handleAudioEnded();
            onEnded();
        };
        audio.addEventListener('play', handlePlay);
        audio.addEventListener('pause', handlePause);
        audio.addEventListener('ended', handleEnded);
        return () => {
            audio.removeEventListener('play', handlePlay);
            audio.removeEventListener('pause', handlePause);
            audio.removeEventListener('ended', handleEnded);
        };
    }, [audioRef, isSameMessage, convertMsToSec]);
    (0, react_1.useEffect)(() => {
        if (!isSameMessage || !audioRef.current?.audio?.current)
            return;
        let raf;
        let cancelled = false;
        const updateTime = () => {
            const audio = audioRef.current?.audio?.current;
            if (!audio || !duration || cancelled)
                return;
            setProgressTime(audioRef.current?.audio?.current.currentTime);
            setRemainingTime(convertMsToSec(duration, audio.currentTime));
            raf = requestAnimationFrame(updateTime);
        };
        raf = requestAnimationFrame(updateTime);
        return () => {
            cancelled = true;
            cancelAnimationFrame(raf);
        };
    }, [isSameMessage, audioRef, duration, convertMsToSec]);
    (0, react_1.useEffect)(() => {
        beepRef.current = new Audio('sound/new_message.mp3');
        beepRef.current.volume = 0.2;
    }, []);
    const playBeep = () => {
        if (!beepRef.current)
            return;
        const sound = beepRef.current.cloneNode(true);
        sound.volume = 0.2;
        sound.play().catch((err) => {
            console.warn('Beep sound failed to play:', err);
        });
    };
    const resetCurrentAudio = () => {
        setIsPlaying(false);
    };
    const handlePlayPause = (manualTrigger) => {
        if (isCurrentlyRecording)
            return;
        if ((manualTrigger && !isPlaying) || !isSameMessage) {
            playAudio(messageId, urlToLoad || '', resetCurrentAudio);
            setIsPlaying(true);
            if (nextMessageToPlayId)
                dispatch((0, conversations_2.setNextMessageToPlayId)(undefined));
        }
        else {
            isManualTriggerForPause.current = true;
            pauseAudio();
        }
    };
    const handleWaveformClick = (e) => {
        if (!isSameMessage || !audioRef.current?.audio?.current)
            return;
        const rect = e.currentTarget.getBoundingClientRect();
        const clickX = e.clientX - rect.left;
        const clickRatio = clickX / rect.width;
        seekTo(clickRatio * duration);
    };
    const handleSeekStart = () => {
        if (!isPlaying)
            return;
        setIsPlaying(false);
        isDraggingRef.current = true;
        isManualTriggerForPause.current = true;
        audioRef.current?.audio?.current?.pause();
    };
    const handleSeekMove = (e) => {
        if (isDraggingRef.current) {
            handleWaveformClick(e);
        }
    };
    const handleSeekEnd = (e) => {
        if (!isDraggingRef.current)
            return;
        setIsPlaying(true);
        isDraggingRef.current = false;
        handleWaveformClick(e);
        isManualTriggerForPause.current = false;
        audioRef.current?.audio?.current?.play();
    };
    const changeSpeed = () => {
        const nextSpeed = playbackSpeed >= 2 ? 1 : playbackSpeed + 0.5;
        if (audioRef.current?.audio?.current) {
            audioRef.current.audio.current.playbackRate = nextSpeed;
        }
        setPlaybackSpeed(nextSpeed);
    };
    const debouncedPlayNextMessage = (0, react_1.useMemo)(() => (0, lodash_1.debounce)((nextId) => {
        dispatch((0, conversations_2.setNextMessageToPlayId)(nextId));
    }, 500), [dispatch]);
    const triggerPlayNextMessageIfNeeded = (endedMessageId) => {
        const justEndedMessageIndex = messageProps.findIndex(m => m.propsForMessage.id === endedMessageId);
        if (justEndedMessageIndex === -1) {
            dispatch((0, conversations_2.setNextMessageToPlayId)(undefined));
            return;
        }
        const isLastMessage = justEndedMessageIndex === 0;
        if (isLastMessage) {
            dispatch((0, conversations_2.setNextMessageToPlayId)(undefined));
            return;
        }
        const nextMessageIndex = justEndedMessageIndex - 1;
        const prevAuthor = messageProps[justEndedMessageIndex].propsForMessage.sender;
        const nextAuthor = messageProps[nextMessageIndex].propsForMessage.sender;
        if (prevAuthor !== nextAuthor) {
            dispatch((0, conversations_2.setNextMessageToPlayId)(undefined));
        }
        else {
            const attachments = messageProps[nextMessageIndex].propsForMessage.attachments;
            if (attachments && (0, Attachment_1.isAudio)(attachments)) {
                playBeep();
                debouncedPlayNextMessage(messageProps[nextMessageIndex].propsForMessage.id);
            }
        }
    };
    const onEnded = () => {
        setIsPlaying(false);
        setRemainingTime(convertMsToSec(duration, 0));
        if (autoPlaySetting && messageId) {
            triggerPlayNextMessageIfNeeded(messageId);
        }
    };
    const barProgressValue = isSameMessage && progressTime && (progressTime !== duration)
        ? progressTime / Math.max(audioContextDuration, 0)
        : 0;
    return (react_1.default.createElement("div", { className: "audio-message" },
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", height: "30px", margin: "10px 0" },
            react_1.default.createElement(icon_1.BchatIconButton, { iconType: isPlaying ? 'pause' : 'play', iconSize: "medium", iconColor: "#F0F0F0", onClick: () => handlePlayPause(true), btnRadius: "40px", btnBgColor: "#2F8FFF", padding: "7px" }),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { role: "button", onClick: changeSpeed, className: (0, classnames_1.default)('play-speed-btn', direction === 'incoming' && 'play-speed-btn-incoming') },
                playbackSpeed,
                "x"),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement(WaveformBar_1.default, { peaks: peaks, progress: barProgressValue, onMouseDown: handleSeekStart, isDragging: isDraggingRef.current, onMouseMove: handleSeekMove, onMouseUp: handleSeekEnd, onMouseLeave: handleSeekEnd, waveColor: waveColor, progressColor: progressColor }),
            react_1.default.createElement("div", { style: { wordBreak: 'keep-all', width: '40px', marginLeft: '5px' } }, remainingTime))));
};
exports.default = WaveFormAudioPlayerWithEncryptedFile;
