"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendFundDisableButton = exports.SendMessageButton = exports.ToggleEmojiButton = exports.StartRecordingButton = exports.AddStagedAttachmentButton = void 0;
const react_1 = __importDefault(require("react"));
const icon_1 = require("../../icon");
const ActionsPanel_1 = require("../../leftpane/ActionsPanel");
const MicrophoneIcon_1 = __importDefault(require("../../icon/MicrophoneIcon"));
const CustomIconButton_1 = require("../../icon/CustomIconButton");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../../state/selectors/theme");
const AddStagedAttachmentButton = (props) => {
    return (react_1.default.createElement("div", { className: "attachment-box", "data-tip": "Attachment", "data-place": "top", "data-offset": "{'right':60}", onClick: props.onClick },
        react_1.default.createElement(ActionsPanel_1.BchatToolTip, { effect: "solid" }),
        react_1.default.createElement(icon_1.BchatIcon, { iconSize: 24, iconType: "attachment", iconColor: "var(--color-icon)" })));
};
exports.AddStagedAttachmentButton = AddStagedAttachmentButton;
const StartRecordingButton = (props) => {
    return (react_1.default.createElement(CustomIconButton_1.CustomIconButton, { className: "recorded-btn", customIcon: react_1.default.createElement(MicrophoneIcon_1.default, { iconSize: 30 }), onClick: props.onClick }));
};
exports.StartRecordingButton = StartRecordingButton;
exports.ToggleEmojiButton = react_1.default.forwardRef((props, ref) => {
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    return (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "emoji", ref: ref, iconColor: darkMode ? '#A7A7BA' : '#ACACAC', iconSize: 'huge', onClick: props.onClick }));
});
const SendMessageButton = (props) => {
    return (react_1.default.createElement("div", { onClick: props.onClick },
        react_1.default.createElement(icon_1.BchatIconButton, { iconType: "send", iconSize: 30, padding: "15px 13px", onClick: props.onClick, dataTestId: "send-message-button" })));
};
exports.SendMessageButton = SendMessageButton;
const SendFundDisableButton = (props) => {
    return (react_1.default.createElement("div", { onClick: props.onClick },
        react_1.default.createElement("div", { "data-tip": "Send BDX", className: "coin-logo-wrapper", "data-offset": "{'top':10,'right':0}" },
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'beldexCoinLogo', iconSize: 20, iconColor: " #888A8D" }))));
};
exports.SendFundDisableButton = SendFundDisableButton;
