"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttachmentSection = void 0;
const react_1 = __importDefault(require("react"));
const DocumentListItem_1 = require("./DocumentListItem");
const MediaGridItem_1 = require("./MediaGridItem");
const missingCaseError_1 = require("../../../util/missingCaseError");
const Items = (props) => {
    const { mediaItems, type } = props;
    return (react_1.default.createElement(react_1.default.Fragment, null, mediaItems.map((mediaItem, position, array) => {
        const shouldShowSeparator = position < array.length - 1;
        const { index, attachment, messageTimestamp, messageId } = mediaItem;
        switch (type) {
            case 'media':
                return (react_1.default.createElement(MediaGridItem_1.MediaGridItem, { key: `${messageId}-${index}`, mediaItem: mediaItem, mediaItems: mediaItems }));
            case 'documents':
                return (react_1.default.createElement(DocumentListItem_1.DocumentListItem, { key: `${messageId}-${index}`, fileName: attachment.fileName, fileSize: attachment.size, shouldShowSeparator: shouldShowSeparator, timestamp: messageTimestamp, mediaItem: mediaItem }));
            default:
                return (0, missingCaseError_1.missingCaseError)(type);
        }
    })));
};
const AttachmentSection = (props) => {
    const { type } = props;
    return (react_1.default.createElement("div", { className: "module-attachment-section" },
        react_1.default.createElement("div", { className: "module-attachment-section__items" },
            react_1.default.createElement("div", { className: `module-attachment-section__items-${type}` },
                react_1.default.createElement(Items, { ...props })))));
};
exports.AttachmentSection = AttachmentSection;
