"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaGridItem = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const GoogleChrome_1 = require("../../../util/GoogleChrome");
const useEncryptedFileFetch_1 = require("../../../hooks/useEncryptedFileFetch");
const conversations_1 = require("../../../state/ducks/conversations");
const useDisableDrag_1 = require("../../../hooks/useDisableDrag");
const MediaGridItemContent = (props) => {
    const { mediaItem } = props;
    const i18n = window.i18n;
    const { attachment, contentType } = mediaItem;
    const urlToDecrypt = mediaItem.thumbnailObjectUrl || '';
    const [imageBroken, setImageBroken] = (0, react_1.useState)(false);
    const { loading, urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(urlToDecrypt, contentType, false);
    const srcData = !loading ? urlToLoad : '';
    const disableDrag = (0, useDisableDrag_1.useDisableDrag)();
    const onImageError = () => {
        setImageBroken(true);
    };
    if (!attachment) {
        return null;
    }
    if (contentType && (0, GoogleChrome_1.isImageTypeSupported)(contentType)) {
        if (imageBroken || !srcData) {
            return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-media-grid-item__icon', 'module-media-grid-item__icon-image') }));
        }
        return (react_1.default.createElement("img", { alt: i18n('lightboxImageAlt'), className: "module-media-grid-item__image", src: srcData, onError: onImageError, onDragStart: disableDrag }));
    }
    else if (contentType && (0, GoogleChrome_1.isVideoTypeSupported)(contentType)) {
        if (imageBroken || !srcData) {
            return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-media-grid-item__icon', 'module-media-grid-item__icon-video') }));
        }
        return (react_1.default.createElement("div", { className: "module-media-grid-item__image-container" },
            react_1.default.createElement("img", { alt: i18n('lightboxImageAlt'), className: "module-media-grid-item__image", src: srcData, onError: onImageError, onDragStart: disableDrag }),
            react_1.default.createElement("div", { className: "module-media-grid-item__circle-overlay" },
                react_1.default.createElement("div", { className: "module-media-grid-item__play-overlay" }))));
    }
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-media-grid-item__icon', 'module-media-grid-item__icon-generic') }));
};
const MediaGridItem = (props) => {
    return (react_1.default.createElement("div", { className: "module-media-grid-item", role: "button", onClick: () => {
            const lightBoxOptions = {
                media: props.mediaItems,
                attachment: props.mediaItem.attachment,
            };
            window.inboxStore?.dispatch((0, conversations_1.showLightBox)(lightBoxOptions));
        } },
        react_1.default.createElement(MediaGridItemContent, { ...props })));
};
exports.MediaGridItem = MediaGridItem;
