"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClickToTrustSender = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const data_1 = require("../../../../data/data");
const conversations_1 = require("../../../../bchat/conversations");
const utils_1 = require("../../../../bchat/utils");
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const BchatButton_1 = require("../../../basic/BchatButton");
const icon_1 = require("../../../icon");
const Flex_1 = require("../../../basic/Flex");
const Attachment_1 = require("../../../../types/Attachment");
const StyledTrustSenderUI = styled_components_1.default.div `
  padding-inline: var(--margins-sm);
  display: flex;
  align-items: center;
  margin: 15px 15px 5px;
  padding: 15px;
  border-radius: 16px;
  background: var(--color-untrust-media-bg);
`;
const ClickToDownload = styled_components_1.default.div `
  cursor: pointer;
  // padding: var(--margins-xs) var(--margins-md);
  white-space: nowrap;
  overflow: hidden;
  // color: #f0f0f0;
  text-overflow: ellipsis;
  font-size: 16px;
  font-weight: 300;
`;
const VerticalLine = styled_components_1.default.div `
  width: 5px;
  background-color: var(--color-untrusted-vertical-bar);
  height: 60px;
  border-radius: 10px;
  margin-right: 10px;
`;
const ImageTxt = styled_components_1.default.span `
  margin-left: 5px;
  // color: #f0f0f0;
  font-family: Poppins;
  font-size: 16px;
  font-weight: 600;
`;
const ClickToTrustSender = (props) => {
    const { attachments } = props;
    const attachmentProps = {
        image: { txt: "Image", icon: "gallery" },
        audio: { txt: "Audio", icon: "audio" },
        video: { txt: "Video", icon: "video" },
        document: { txt: "Document", icon: "document" }
    };
    const getAttachmentType = (attachments) => {
        if ((0, Attachment_1.isImage)(attachments))
            return attachmentProps.image;
        if ((0, Attachment_1.isAudio)(attachments))
            return attachmentProps.audio;
        if ((0, Attachment_1.isVideo)(attachments))
            return attachmentProps.video;
        return attachmentProps.document;
    };
    const attachmentType = getAttachmentType(attachments);
    const openConfirmationModal = async (e) => {
        e.stopPropagation();
        e.preventDefault();
        const found = await (0, data_1.getMessageById)(props.messageId);
        if (!found) {
            window.log.warn('message not found ClickToTrustSender');
            return;
        }
        const sender = found.getSource();
        const convo = (0, conversations_1.getConversationController)().get(sender);
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
            title: window.i18n('trustThisContactDialogTitle', [
                convo.getContactProfileNameOrShortenedPubKey(),
            ]),
            message: `${window.i18n('trustThisContactDialogDescription')}<div style="color:#EBEBEB; font-weight:400;text-transform: capitalize;">${convo.getContactProfileNameOrShortenedPubKey()} ?</div>`,
            okTheme: BchatButton_1.BchatButtonColor.Primary,
            okText: window.i18n('autoUpdateDownloadButtonLabel'),
            iconShow: true,
            customIcon: react_1.default.createElement(icon_1.BchatIcon, { iconType: 'trustDownloadMedia', iconSize: 30 }),
            onClickOk: async () => {
                convo.set({ isTrustedForAttachmentDownload: true });
                await convo.commit();
                const messagesInConvo = await (0, data_1.getLastMessagesByConversation)(convo.id, 100, false);
                await Promise.all(messagesInConvo.map(async (message) => {
                    const msgAttachments = message.get('attachments');
                    const messagePreviews = message.get('preview');
                    if (message.get('direction') !== 'incoming') {
                        return;
                    }
                    if ((!msgAttachments || msgAttachments.length === 0) &&
                        (!messagePreviews || messagePreviews.length === 0)) {
                        return;
                    }
                    const downloadedAttachments = await Promise.all(msgAttachments.map(async (attachment, index) => {
                        if (attachment.path) {
                            return { ...attachment, pending: false };
                        }
                        return utils_1.AttachmentDownloads.addJob(attachment, {
                            messageId: message.id,
                            type: 'attachment',
                            index,
                            isOpenGroupV2: false,
                            openGroupV2Details: undefined,
                        });
                    }));
                    const preview = await Promise.all((messagePreviews || []).map(async (item, index) => {
                        if (!item.image) {
                            return item;
                        }
                        const image = message.isTrustedForAttachmentDownload()
                            ? await utils_1.AttachmentDownloads.addJob(item.image, {
                                messageId: message.id,
                                type: 'preview',
                                index,
                                isOpenGroupV2: false,
                                openGroupV2Details: undefined,
                            })
                            : null;
                        return { ...item, image };
                    }));
                    message.set({ preview });
                    message.set({ attachments: downloadedAttachments });
                    await message.commit();
                }));
            },
        }));
    };
    return (react_1.default.createElement(StyledTrustSenderUI, { onClick: openConfirmationModal },
        react_1.default.createElement(VerticalLine, null),
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column" },
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center" },
                react_1.default.createElement(icon_1.BchatIcon, { iconSize: "small", iconType: attachmentType.icon }),
                react_1.default.createElement(ImageTxt, null, attachmentType.txt)),
            react_1.default.createElement(ClickToDownload, null, window.i18n('clickToTrustContact')))));
};
exports.ClickToTrustSender = ClickToTrustSender;
