"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageAttachment = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const lodash_1 = require("lodash");
const data_1 = require("../../../../data/data");
const conversations_1 = require("../../../../state/ducks/conversations");
const conversations_2 = require("../../../../state/selectors/conversations");
const Attachment_1 = require("../../../../types/Attachment");
const attachmentsUtil_1 = require("../../../../util/attachmentsUtil");
const Spinner_1 = require("../../../basic/Spinner");
const ImageGrid_1 = require("../../ImageGrid");
const ClickToTrustSender_1 = require("./ClickToTrustSender");
const WaveFormAudioPlayer_1 = __importDefault(require("../../WaveFormAudioPlayer"));
const MessageAttachment = (props) => {
    const { messageId, imageBroken, handleImageError, displayBgBlur } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const attachmentProps = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageAttachmentProps)(state, messageId));
    const multiSelectMode = (0, react_redux_1.useSelector)(conversations_2.isMessageSelectionMode);
    const onClickOnImageGrid = (0, react_1.useCallback)((attachment) => {
        if (multiSelectMode) {
            dispatch((0, conversations_1.toggleSelectedMessageId)(messageId));
        }
        else {
            void onClickAttachment({
                attachment,
                messageId,
            });
        }
    }, [messageId, multiSelectMode]);
    const onClickOnGenericAttachment = (0, react_1.useCallback)((e) => {
        e.stopPropagation();
        e.preventDefault();
        if (!attachments?.length) {
            return;
        }
        const messageTimestamp = attachmentProps?.timestamp || attachmentProps?.serverTimestamp || 0;
        if (attachmentProps?.sender && attachmentProps?.convoId) {
            void (0, attachmentsUtil_1.saveAttachmentToDisk)({
                attachment: attachments[0],
                messageTimestamp,
                messageSender: attachmentProps?.sender,
                conversationId: attachmentProps?.convoId,
            });
        }
    }, [
        attachmentProps?.attachments,
        attachmentProps?.timestamp,
        attachmentProps?.serverTimestamp,
        attachmentProps?.sender,
        attachmentProps?.convoId,
    ]);
    if (!attachmentProps) {
        return null;
    }
    const { attachments, direction, isTrustedForAttachmentDownload } = attachmentProps;
    if (!attachments || !attachments[0]) {
        return null;
    }
    const firstAttachment = attachments[0];
    const displayImage = (0, Attachment_1.canDisplayImage)(attachments);
    if (!isTrustedForAttachmentDownload) {
        return react_1.default.createElement(ClickToTrustSender_1.ClickToTrustSender, { messageId: messageId, attachments: attachments });
    }
    if (displayImage &&
        !imageBroken &&
        (((0, Attachment_1.isImage)(attachments) && (0, Attachment_1.hasImage)(attachments)) ||
            ((0, Attachment_1.isVideo)(attachments) && (0, Attachment_1.hasVideoScreenshot)(attachments)))) {
        return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__attachment-container', displayBgBlur && 'module-message__attachment-container-displayBgBlur') },
            react_1.default.createElement(ImageGrid_1.ImageGrid, { attachments: attachments, onError: handleImageError, onClickAttachment: onClickOnImageGrid })));
    }
    else if (!firstAttachment.pending && !firstAttachment.error && (0, Attachment_1.isAudio)(attachments)) {
        return (react_1.default.createElement("div", { role: "main", onClick: (e) => {
                if (multiSelectMode) {
                    dispatch((0, conversations_1.toggleSelectedMessageId)(messageId));
                }
                e.stopPropagation();
                e.preventDefault();
            }, style: { padding: '5px 10px 5px 15px' } },
            react_1.default.createElement(WaveFormAudioPlayer_1.default, { src: firstAttachment.url, contentType: firstAttachment.contentType, messageId: messageId, direction: direction, size: firstAttachment.size })));
    }
    else {
        const { pending, fileName, fileSize, contentType } = firstAttachment;
        const extension = (0, Attachment_1.getExtensionForDisplay)({ contentType, fileName });
        return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__generic-attachment ', `module-message__generic-attachment-${direction}`) },
            pending ? (react_1.default.createElement("div", { className: "module-message__generic-attachment__spinner-container" },
                react_1.default.createElement(Spinner_1.Spinner, { size: "small" }))) : (react_1.default.createElement("div", { className: "module-message__generic-attachment__icon-container" },
                react_1.default.createElement("div", { role: "button", className: "module-message__generic-attachment__icon", onClick: onClickOnGenericAttachment }, extension ? (react_1.default.createElement("div", { className: "module-message__generic-attachment__icon__extension" }, extension)) : null))),
            react_1.default.createElement("div", { className: "module-message__generic-attachment__text", onClick: onClickOnGenericAttachment, role: 'button' },
                react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__generic-attachment__file-name', `module-message__generic-attachment__file-name--${direction}`) }, fileName),
                react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__generic-attachment__file-size', `module-message__generic-attachment__file-size--${direction}`) }, fileSize))));
    }
};
exports.MessageAttachment = MessageAttachment;
function attachmentIsAttachmentTypeWithPath(attac) {
    return attac.path !== undefined;
}
const onClickAttachment = async (onClickProps) => {
    let index = -1;
    const found = await (0, data_1.getMessageById)(onClickProps.messageId);
    if (!found) {
        window.log.warn('Such message not found');
        return;
    }
    const msgAttachments = found.getPropsForMessage().attachments;
    const media = (msgAttachments || []).map(attachmentForMedia => {
        index++;
        const messageTimestamp = found.get('timestamp') || found.get('serverTimestamp') || found.get('received_at');
        return {
            index: (0, lodash_1.clone)(index),
            objectURL: attachmentForMedia.url || undefined,
            contentType: attachmentForMedia.contentType,
            attachment: attachmentForMedia,
            messageSender: found.getSource(),
            messageTimestamp,
            messageId: onClickProps.messageId,
        };
    });
    if (attachmentIsAttachmentTypeWithPath(onClickProps.attachment)) {
        const lightBoxOptions = {
            media: media,
            attachment: onClickProps.attachment,
        };
        window.inboxStore?.dispatch((0, conversations_1.showLightBox)(lightBoxOptions));
    }
    else {
        window.log.warn('Attachment is not of the right type');
    }
};
