"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageBody = exports.renderTextDefault = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const electron_1 = require("electron");
const linkify_it_1 = __importDefault(require("linkify-it"));
const emoji_1 = require("../../../../util/emoji");
const AddMentions_1 = require("../../AddMentions");
const AddNewLines_1 = require("../../AddNewLines");
const Emojify_1 = require("../../Emojify");
const interactions_1 = require("../../../../interactions");
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const linkPreviews_1 = require("../../../../util/linkPreviews");
const BchatButton_1 = require("../../../basic/BchatButton");
const BchatIcon_1 = require("../../../icon/BchatIcon");
const linkify = (0, linkify_it_1.default)();
const renderMentions = ({ text, key, isGroup }) => (react_1.default.createElement(AddMentions_1.AddMentions, { key: key, text: text, isGroup: isGroup }));
const renderTextDefault = ({ text }) => react_1.default.createElement(react_1.default.Fragment, null, text);
exports.renderTextDefault = renderTextDefault;
const renderNewLines = ({ text: textWithNewLines, key, isGroup }) => {
    const renderOther = isGroup ? renderMentions : exports.renderTextDefault;
    return (react_1.default.createElement(AddNewLines_1.AddNewLines, { key: key, text: textWithNewLines, renderNonNewLine: renderOther, isGroup: isGroup }));
};
const renderEmoji = ({ text, key, sizeClass, renderNonEmoji, isGroup, }) => (react_1.default.createElement(Emojify_1.Emojify, { key: key, text: text, sizeClass: sizeClass, renderNonEmoji: renderNonEmoji, isGroup: isGroup }));
const JsxSelectable = (jsx) => {
    return (react_1.default.createElement("span", { className: "text-selectable", onDragStart: (e) => {
            e.preventDefault();
            e.stopPropagation();
            return false;
        } }, jsx));
};
const MessageBody = (props) => {
    const { text, disableJumbomoji, disableLinks, isGroup } = props;
    const sizeClass = disableJumbomoji ? 'default' : (0, emoji_1.getEmojiSizeClass)(text);
    if (disableLinks) {
        return JsxSelectable(renderEmoji({
            text,
            sizeClass,
            key: 0,
            renderNonEmoji: renderNewLines,
            isGroup,
        }));
    }
    if (text && text.startsWith('```') && text.endsWith('```')) {
        return react_1.default.createElement("pre", { className: "text-selectable" }, text.substring(4, text.length - 3));
    }
    return JsxSelectable(react_1.default.createElement(Linkify, { text: text, isGroup: isGroup, renderNonLink: ({ key, text: nonLinkText }) => {
            return renderEmoji({
                text: nonLinkText,
                sizeClass,
                key,
                renderNonEmoji: renderNewLines,
                isGroup,
            });
        } }));
};
exports.MessageBody = MessageBody;
const SUPPORTED_PROTOCOLS = /^(http|https):/i;
const Linkify = (props) => {
    const { text, isGroup, renderNonLink } = props;
    const results = [];
    let count = 1;
    const dispatch = (0, react_redux_1.useDispatch)();
    const matchData = linkify.match(text) || [];
    let last = 0;
    const handleClick = (0, react_1.useCallback)((e) => {
        e.preventDefault();
        e.stopPropagation();
        const url = e.target.href;
        const openLink = () => {
            void electron_1.shell.openExternal(url);
        };
        dispatch((0, modalDialog_1.updateConfirmModal)({
            title: window.i18n('linkVisitWarningTitle'),
            message: window.i18n('linkVisitWarningMessage', url),
            okText: window.i18n('openLink'),
            cancelText: window.i18n('editMenuCopy'),
            showExitIcon: true,
            iconShow: true,
            customIcon: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'openLink', iconSize: 30 }),
            okTheme: BchatButton_1.BchatButtonColor.Primary,
            onClickOk: openLink,
            onClickClose: () => {
                dispatch((0, modalDialog_1.updateConfirmModal)(null));
            },
            onClickCancel: () => {
                interactions_1.MessageInteraction.copyBodyToClipboard(url);
            },
            okIcon: { icon: "openLinkBtn", size: 20 },
            cancelIcon: { icon: "copy", size: 20 }
        }));
    }, []);
    if (matchData.length === 0) {
        return renderNonLink({ text, key: 0, isGroup });
    }
    matchData.forEach((match) => {
        if (last < match.index) {
            const textWithNoLink = text.slice(last, match.index);
            results.push(renderNonLink({ text: textWithNoLink, isGroup, key: count++ }));
        }
        const { url, text: originalText } = match;
        const isLink = SUPPORTED_PROTOCOLS.test(url) && !linkPreviews_1.LinkPreviews.isLinkSneaky(url);
        if (isLink) {
            results.push(react_1.default.createElement("a", { key: count++, href: url, onClick: handleClick }, originalText));
        }
        else {
            results.push(renderNonLink({ text: originalText, isGroup, key: count++ }));
        }
        last = match.lastIndex;
    });
    if (last < text.length) {
        results.push(renderNonLink({ text: text.slice(last), isGroup, key: count++ }));
    }
    return react_1.default.createElement(react_1.default.Fragment, null, results);
};
