"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageContent = exports.IsMessageVisibleContext = exports.StyledSvgWrapper = void 0;
const classnames_1 = __importDefault(require("classnames"));
const moment_1 = __importDefault(require("moment"));
const react_1 = __importStar(require("react"));
const react_intersection_observer_1 = require("react-intersection-observer");
const react_redux_1 = require("react-redux");
const lodash_1 = require("lodash");
const conversations_1 = require("../../../../state/selectors/conversations");
const Flex_1 = require("../../../basic/Flex");
const MessageAttachment_1 = require("./MessageAttachment");
const MessagePreview_1 = require("./MessagePreview");
const MessageQuote_1 = require("./MessageQuote");
const MessageText_1 = require("./MessageText");
const BchatMessagesListContainer_1 = require("../../BchatMessagesListContainer");
const MessageAuthorText_1 = require("./MessageAuthorText");
const styled_components_1 = __importDefault(require("styled-components"));
const IncomingMsgTailIcon_1 = __importDefault(require("../../../icon/IncomingMsgTailIcon"));
const OutgoingMsgTailIcon_1 = __importDefault(require("../../../icon/OutgoingMsgTailIcon"));
exports.StyledSvgWrapper = styled_components_1.default.div `
    position: absolute;
    z-index: 19;
    bottom: 0px;
`;
function onClickOnMessageInnerContainer(event) {
    const selection = window.getSelection();
    if (selection && selection.type === 'Range') {
        return;
    }
    const target = event.target;
    if (target.className === 'text-selectable' || window.contextMenuShown) {
        return;
    }
}
exports.IsMessageVisibleContext = (0, react_1.createContext)(false);
const MessageContent = (props) => {
    const [flashGreen, setFlashGreen] = (0, react_1.useState)(false);
    const [didScroll, setDidScroll] = (0, react_1.useState)(false);
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageContentSelectorProps)(state, props.messageId));
    const [isMessageVisible, setMessageIsVisible] = (0, react_1.useState)(false);
    const scrollToLoadedMessage = (0, react_1.useContext)(BchatMessagesListContainer_1.ScrollToLoadedMessageContext);
    const [imageBroken, setImageBroken] = (0, react_1.useState)(false);
    const onVisible = (inView) => {
        if (inView === true ||
            (inView.type === 'focus' && inView.returnValue === true)) {
            if (isMessageVisible !== true) {
                setMessageIsVisible(true);
            }
        }
    };
    const handleImageError = (0, react_1.useCallback)(() => {
        setImageBroken(true);
    }, [setImageBroken]);
    const quotedMessageToAnimate = (0, react_redux_1.useSelector)(conversations_1.getQuotedMessageToAnimate);
    const shouldHighlightMessage = (0, react_redux_1.useSelector)(conversations_1.getShouldHighlightMessage);
    const isQuotedMessageToAnimate = quotedMessageToAnimate === props.messageId;
    const quoteMessageprops = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageQuoteProps)(state, props.messageId));
    const quote = quoteMessageprops?.quote;
    (0, react_1.useLayoutEffect)(() => {
        if (isQuotedMessageToAnimate) {
            if (!flashGreen && !didScroll) {
                scrollToLoadedMessage(props.messageId, 'quote-or-search-result');
                setDidScroll(true);
                if (shouldHighlightMessage) {
                    setFlashGreen(true);
                }
            }
            return;
        }
        if (flashGreen) {
            setFlashGreen(false);
        }
        if (didScroll) {
            setDidScroll(false);
        }
        return;
    });
    if (!contentProps) {
        return null;
    }
    const { direction, text, timestamp, serverTimestamp, firstMessageOfSeries, lastMessageOfSeries, previews, attachments = [], } = contentProps;
    const { isTrustedForAttachmentDownload } = props;
    const selectedMsg = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageTextProps)(state, props.messageId));
    let isDeleted = false;
    if (selectedMsg && selectedMsg.isDeleted !== undefined) {
        isDeleted = selectedMsg.isDeleted;
    }
    const hasText = Boolean(text);
    const hasQuote = !(0, lodash_1.isEmpty)(quote);
    const hasAttachment = attachments.length > 0;
    const hasContentAfterAttachmentAndQuote = !(0, lodash_1.isEmpty)(previews) || !(0, lodash_1.isEmpty)(text);
    const isIncoming = direction === 'incoming';
    const isGifAttachments = (isIncoming ? isTrustedForAttachmentDownload : true) && attachments.length === 1 && attachments[0].contentType === 'image/gif' && !hasText && !hasQuote;
    const toolTipTitle = (0, moment_1.default)(serverTimestamp || timestamp).format('llll');
    const isTailVisible = lastMessageOfSeries && !props.isDetailView && !isGifAttachments;
    return (react_1.default.createElement("div", { style: { position: 'relative' } },
        isTailVisible && isIncoming && react_1.default.createElement(exports.StyledSvgWrapper, null,
            react_1.default.createElement(IncomingMsgTailIcon_1.default, null)),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__container', `module-message__container--${direction}`, `module-message__container--${direction}--opaque`, firstMessageOfSeries && !lastMessageOfSeries || props.isDetailView
                ? `module-message__container--${direction}--first-of-series`
                : '', lastMessageOfSeries || props.isDetailView
                ? `module-message__container--${direction}--last-of-series`
                : '', flashGreen && 'flash-green-once', isGifAttachments && `module-message__container_bg_disabled`, hasAttachment && !hasText && 'module-message__container-only-attachment'), role: "button", onMouseEnter: () => {
                props.onRecentEmojiBtnVisible();
            }, onClick: onClickOnMessageInnerContainer, title: toolTipTitle },
            react_1.default.createElement(MessageAuthorText_1.MessageAuthorText, { messageId: props.messageId }),
            react_1.default.createElement(react_intersection_observer_1.InView, { id: `inview-content-${props.messageId}`, onChange: onVisible, threshold: 0, rootMargin: "500px 0px 500px 0px", triggerOnce: false },
                react_1.default.createElement(exports.IsMessageVisibleContext.Provider, { value: isMessageVisible },
                    !isDeleted && (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement(MessageQuote_1.MessageQuote, { messageId: props.messageId }),
                        react_1.default.createElement(MessageAttachment_1.MessageAttachment, { messageId: props.messageId, imageBroken: imageBroken, handleImageError: handleImageError, displayBgBlur: hasAttachment && hasText }))),
                    hasContentAfterAttachmentAndQuote ? (react_1.default.createElement(react_1.default.Fragment, null,
                        !isDeleted && (react_1.default.createElement(MessagePreview_1.MessagePreview, { messageId: props.messageId, handleImageError: handleImageError, direction: direction })),
                        react_1.default.createElement(Flex_1.Flex, { padding: "0 15px", container: true, flexDirection: "column", className: (0, classnames_1.default)(hasAttachment && hasText && 'attachment-with-quote') },
                            react_1.default.createElement(MessageText_1.MessageText, { messageId: props.messageId })))) : null,
                    !props.isDetailView && react_1.default.createElement("div", { className: "timeStamp" }, (0, moment_1.default)(timestamp).format('hh:mm A'))))),
        isTailVisible && !isIncoming && react_1.default.createElement(exports.StyledSvgWrapper, { style: { right: 0 } },
            react_1.default.createElement(OutgoingMsgTailIcon_1.default, null))));
};
exports.MessageContent = MessageContent;
