"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageContentWithStatuses = exports.StyledMessageContentContainer = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const conversationInteractions_1 = require("../../../../interactions/conversationInteractions");
const conversations_1 = require("../../../../state/ducks/conversations");
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const conversations_2 = require("../../../../state/selectors/conversations");
const MessageContent_1 = require("./MessageContent");
const MessageContextMenu_1 = require("./MessageContextMenu");
const MessageStatus_1 = require("./MessageStatus");
const ExpireTimer_1 = require("../../ExpireTimer");
const styled_components_1 = __importDefault(require("styled-components"));
const MessageReactions_1 = require("./MessageReactions");
const reactions_1 = require("../../../../util/reactions");
const Flex_1 = require("../../../basic/Flex");
const MessageReactBar_1 = require("./MessageReactBar");
const BchatEmojiPanel_1 = require("../../BchatEmojiPanel");
const react_use_1 = require("react-use");
const icon_1 = require("../../../icon");
const theme_1 = require("../../../../state/selectors/theme");
exports.StyledMessageContentContainer = styled_components_1.default.div `
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
  align-items: ${props => (props.direction === 'left' ? 'flex-start' : 'flex-end')};
  width: 100%;
`;
const StyledEmojiPanelContainer = styled_components_1.default.div `
  position: fixed;
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
  z-index: 101;
  ${BchatEmojiPanel_1.StyledEmojiPanel} {
    position: absolute;
    left: ${props => `${props.x}px`};
    top: ${props => `${props.y}px`};
  }
`;
const StyledMessageReactBarInnerWrapper = styled_components_1.default.div `
  position: absolute;
  left: ${props => `${props.isIncoming ? 4 : -248}px`};
  z-index: 1;
`;
const StyledRecentReactionWrapper = styled_components_1.default.div `
  position: relative;
`;
const RecentReacts = (props) => {
    const { isIncoming, recentEmojiBtnVisible, onEmojiClick, onRecentEmojiBtnVisible } = props;
    if (!recentEmojiBtnVisible) {
        return null;
    }
    const [recentEmoji, setRecentEmoji] = (0, react_1.useState)(false);
    const emojiPanelRef = (0, react_1.useRef)(null);
    const [showEmojiPanel, setShowEmojiPanel] = (0, react_1.useState)(false);
    const emojiPanelHeight = 435;
    const [mouseX, setMouseX] = (0, react_1.useState)(0);
    const [mouseY, setMouseY] = (0, react_1.useState)(0);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const onShowEmoji = (e) => {
        const panelHeight = emojiPanelHeight;
        let x = e.clientX;
        let y = e.clientY - 39;
        if (isIncoming) {
            x -= 240;
        }
        else {
            x -= 150;
        }
        if (y + panelHeight > window.innerHeight) {
            y = window.innerHeight - panelHeight - 10 - 80;
        }
        else if (y < 10) {
            y = 10;
        }
        setMouseX(x);
        setMouseY(y);
        setShowEmojiPanel(true);
        setRecentEmoji(false);
    };
    const onEmojiKeyDown = (event) => {
        if (event.key === 'Escape' && showEmojiPanel) {
            onCloseEmoji();
        }
    };
    (0, react_use_1.useClickAway)(emojiPanelRef, () => {
        onCloseEmoji();
    });
    const onCloseEmoji = () => {
        setShowEmojiPanel(false);
        onRecentEmojiBtnVisible();
        setRecentEmoji(false);
    };
    const onSubmit = (e) => {
        onEmojiClick(e);
        onCloseEmoji();
    };
    return (react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: isIncoming ? 'row' : 'row-reverse', alignItems: "center" },
        react_1.default.createElement("div", null,
            react_1.default.createElement(icon_1.BchatIconButton, { iconType: "smileyEmoji", iconSize: 20, iconColor: darkMode ? '#858598' : '#ACACAC', onClick: () => setRecentEmoji(!recentEmoji), margin: "0 5px", btnBgColor: darkMode ? '#2E333D' : '#F8F8F8', btnRadius: "30px", style: {} })),
        recentEmoji && (react_1.default.createElement("div", { style: { height: '46px', position: 'relative' } },
            react_1.default.createElement(StyledMessageReactBarInnerWrapper, { isIncoming: isIncoming, className: "Message-ReactBar-Inner" },
                react_1.default.createElement(MessageReactBar_1.MessageReactBar, { action: onSubmit, additionalAction: e => onShowEmoji(e), isIncoming: isIncoming })))),
        showEmojiPanel && (react_1.default.createElement(StyledEmojiPanelContainer, { onKeyDown: onEmojiKeyDown, role: "button", x: mouseX, y: mouseY },
            react_1.default.createElement(BchatEmojiPanel_1.BchatEmojiPanel, { ref: emojiPanelRef, onEmojiClicked: onSubmit, show: showEmojiPanel, isModal: true })))));
};
const ThreeDotsMenu = (props) => {
    const { darkMode, onHandleContextMenu } = props;
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'filledThreeDots', iconSize: 20, iconColor: darkMode ? '#858598' : '#ACACAC', onClick: onHandleContextMenu, margin: "0 2.5px", btnBgColor: darkMode ? '#2E333D' : '#F8F8F8', btnRadius: "30px" })));
};
const MessageContentWithStatuses = (props) => {
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageContentWithStatusesSelectorProps)(state, props.messageId));
    const typingEnabled = (0, react_redux_1.useSelector)(conversations_2.getIsTypingEnabled);
    const dispatch = (0, react_redux_1.useDispatch)();
    const multiSelectMode = (0, react_redux_1.useSelector)(conversations_2.isMessageSelectionMode);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageStatusProps)(state, props.messageId));
    if (!selected) {
        return null;
    }
    const { status } = selected;
    const onClickOnMessageOuterContainer = (0, react_1.useCallback)((event) => {
        if (multiSelectMode && messageId) {
            event.preventDefault();
            event.stopPropagation();
            dispatch((0, conversations_1.toggleSelectedMessageId)(messageId));
        }
    }, [window.contextMenuShown, props?.messageId, multiSelectMode, props?.isDetailView]);
    const onDoubleClickReplyToMessage = (e) => {
        const currentSelection = window.getSelection();
        const currentSelectionString = currentSelection?.toString() || undefined;
        if (!currentSelectionString ||
            currentSelectionString.length === 0 ||
            !currentSelectionString.includes(' ')) {
            void (0, conversationInteractions_1.replyToMessage)(messageId);
            currentSelection?.empty();
            e.preventDefault();
            return;
        }
    };
    const { messageId, ctxMenuID, isDetailView, dataTestId, expirationLength, expirationTimestamp, enableReactions, isRightClicked, onMessageLoseFocus, onHandleContextMenu, acceptUrl, txnId, cardDesignTag, recentEmojiBtnVisible, setRecentEmojiBtnVisible, } = props;
    const [popupReaction, setPopupReaction] = (0, react_1.useState)('');
    const handleMessageReaction = async (emoji) => {
        await (0, reactions_1.sendMessageReaction)(messageId, emoji);
    };
    const handlePopupClick = () => {
        setPopupReaction('');
        setRecentEmojiBtnVisible(false);
        dispatch((0, modalDialog_1.updateReactListModal)({ reaction: popupReaction, messageId }));
    };
    if (!contentProps) {
        return null;
    }
    const { direction, isDeleted, hasAttachments, isTrustedForAttachmentDownload, isPublic, } = contentProps;
    const isIncoming = direction === 'incoming';
    const emojiIsVisible = !isDeleted &&
        !multiSelectMode &&
        !isPublic &&
        (!hasAttachments || isTrustedForAttachmentDownload) &&
        status !== 'sending' &&
        status !== 'error' &&
        typingEnabled &&
        !isRightClicked && !isDetailView;
    const threeDotVisible = recentEmojiBtnVisible && !isRightClicked && !isDetailView;
    const onEmojiClick = async (args) => {
        const emoji = args.native ?? args;
        await (0, reactions_1.sendMessageReaction)(messageId, emoji);
    };
    return (react_1.default.createElement(exports.StyledMessageContentContainer, { direction: isIncoming ? 'left' : 'right', onMouseLeave: () => {
            setPopupReaction('');
            setRecentEmojiBtnVisible(false);
        } },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message', `module-message--${direction}`, isDetailView && 'module-message--detailview'), role: "button", onClick: onClickOnMessageOuterContainer, style: {
                width: hasAttachments && isTrustedForAttachmentDownload ? 'min-content' : 'auto',
            }, "data-testid": dataTestId },
            multiSelectMode && react_1.default.createElement("div", { className: "module-message--multiSelect-overlay" }),
            !isIncoming && (react_1.default.createElement(Flex_1.Flex, { container: true, width: "165px", justifyContent: "flex-end" },
                threeDotVisible && (react_1.default.createElement("div", { className: 'module-message--three-dot' },
                    react_1.default.createElement(ThreeDotsMenu, { darkMode: darkMode, onHandleContextMenu: onHandleContextMenu }))),
                emojiIsVisible && (react_1.default.createElement(StyledRecentReactionWrapper, null,
                    react_1.default.createElement(RecentReacts, { isIncoming: isIncoming, recentEmojiBtnVisible: recentEmojiBtnVisible, onEmojiClick: onEmojiClick, onRecentEmojiBtnVisible: () => setRecentEmojiBtnVisible(false) }))))),
            expirationLength && expirationTimestamp && (status === 'sent' || status === 'read') ? (react_1.default.createElement(ExpireTimer_1.ExpireTimer, { isCorrectSide: !isIncoming, expirationLength: expirationLength, expirationTimestamp: expirationTimestamp })) : (react_1.default.createElement(MessageStatus_1.MessageStatus, { dataTestId: "msg-status-outgoing", messageId: messageId, isCorrectSide: !isIncoming && !isDetailView, status: status })),
            react_1.default.createElement("div", { onDoubleClickCapture: onDoubleClickReplyToMessage }, cardDesignTag ?? (react_1.default.createElement(MessageContent_1.MessageContent, { messageId: messageId, isDetailView: isDetailView, onRecentEmojiBtnVisible: () => setRecentEmojiBtnVisible(true), isTrustedForAttachmentDownload: isTrustedForAttachmentDownload }))),
            expirationLength && expirationTimestamp ? (react_1.default.createElement(ExpireTimer_1.ExpireTimer, { isCorrectSide: isIncoming, expirationLength: expirationLength, expirationTimestamp: expirationTimestamp })) : (react_1.default.createElement(MessageStatus_1.MessageStatus, { dataTestId: "msg-status-incoming", messageId: messageId, isCorrectSide: isIncoming, status: status })),
            isIncoming && (react_1.default.createElement(Flex_1.Flex, { container: true, width: "165px" },
                emojiIsVisible && (react_1.default.createElement(StyledRecentReactionWrapper, null,
                    react_1.default.createElement(RecentReacts, { isIncoming: isIncoming, recentEmojiBtnVisible: recentEmojiBtnVisible, onEmojiClick: onEmojiClick, onRecentEmojiBtnVisible: () => setRecentEmojiBtnVisible(false) }))),
                threeDotVisible && (react_1.default.createElement(ThreeDotsMenu, { darkMode: darkMode, onHandleContextMenu: onHandleContextMenu })))),
            !isDetailView && (react_1.default.createElement(MessageContextMenu_1.MessageContextMenu, { messageId: messageId, contextMenuId: ctxMenuID, enableReactions: enableReactions, onMessageLoseFocus: onMessageLoseFocus, acceptUrl: acceptUrl, txnId: txnId }))),
        enableReactions && !isDetailView && (react_1.default.createElement(MessageReactions_1.MessageReactions, { messageId: messageId, onClick: handleMessageReaction, popupReaction: popupReaction, setPopupReaction: e => {
                setPopupReaction(e), setRecentEmojiBtnVisible(false);
            }, onPopupClick: handlePopupClick, isIncoming: isIncoming }))));
};
exports.MessageContentWithStatuses = MessageContentWithStatuses;
