"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageContextMenu = void 0;
const react_1 = __importStar(require("react"));
const react_contexify_1 = require("react-contexify");
const react_redux_1 = require("react-redux");
const data_1 = require("../../../../data/data");
const interactions_1 = require("../../../../interactions");
const conversationInteractions_1 = require("../../../../interactions/conversationInteractions");
const unsendingInteractions_1 = require("../../../../interactions/conversations/unsendingInteractions");
const messageInteractions_1 = require("../../../../interactions/messageInteractions");
const Toast_1 = require("../../../../bchat/utils/Toast");
const conversations_1 = require("../../../../state/ducks/conversations");
const conversations_2 = require("../../../../state/selectors/conversations");
const attachmentsUtil_1 = require("../../../../util/attachmentsUtil");
const icon_1 = require("../../../icon");
const CopyIcon_1 = __importDefault(require("../../../icon/CopyIcon"));
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const react_use_1 = require("react-use");
const MessageContextMenu = (props) => {
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageContextMenuProps)(state, props.messageId));
    const dispatch = (0, react_redux_1.useDispatch)();
    const contextMenuRef = (0, react_1.useRef)(null);
    if (!selected) {
        return null;
    }
    (0, react_use_1.useClickAway)(contextMenuRef, () => {
        react_contexify_1.contextMenu.hideAll();
        props.onMessageLoseFocus();
    });
    const { attachments, sender, convoId, direction, status, isDeletable, isDeletableForEveryone, isPublic, isOpenGroupV2, weAreAdmin, isSenderAdmin, text, serverTimestamp, timestamp, isBlocked, isDeleted, } = selected;
    const { messageId, contextMenuId, acceptUrl, txnId } = props;
    const isPrivate = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversation)?.isPrivate;
    const isOutgoing = direction === 'outgoing';
    const showRetry = status === 'error' && isOutgoing;
    const isSent = status === 'sent' || status === 'read';
    const [showEmojiPanel, setShowEmojiPanel] = (0, react_1.useState)(false);
    const onContextMenuShown = () => {
        if (showEmojiPanel) {
            setShowEmojiPanel(false);
        }
        window.contextMenuShown = true;
    };
    const onContextMenuHidden = (0, react_1.useCallback)(() => {
        setTimeout(() => {
            window.contextMenuShown = false;
        }, 100);
    }, []);
    const onShowDetail = async () => {
        const found = await (0, data_1.getMessageById)(messageId);
        if (found) {
            const messageDetailsProps = await found.getPropsForMessageDetail();
            dispatch((0, modalDialog_1.updateMessageMoreInfoModal)(messageDetailsProps));
        }
        else {
            window.log.warn(`Message ${messageId} not found in db`);
        }
    };
    const selectMessageText = window.i18n('selectMessage');
    const deleteMessageJustForMeText = window.i18n('deleteJustForMe');
    const unsendMessageText = window.i18n('deleteForEveryone');
    const addModerator = (0, react_1.useCallback)(() => {
        void (0, messageInteractions_1.addSenderAsModerator)(sender, convoId);
    }, [sender, convoId]);
    const removeModerator = (0, react_1.useCallback)(() => {
        void (0, messageInteractions_1.removeSenderFromModerator)(sender, convoId);
    }, [sender, convoId]);
    const onReply = (0, react_1.useCallback)(() => {
        if (isBlocked) {
            (0, Toast_1.pushUnblockToSend)();
            return;
        }
        void (0, conversationInteractions_1.replyToMessage)(messageId);
    }, [isBlocked, messageId]);
    const saveAttachment = (0, react_1.useCallback)((e) => {
        let targetAttachmentIndex = e.triggerEvent.path[1].getAttribute('data-attachmentindex');
        e.event.stopPropagation();
        if (!attachments?.length) {
            return;
        }
        if (!targetAttachmentIndex) {
            targetAttachmentIndex = 0;
        }
        if (targetAttachmentIndex > attachments.length) {
            return;
        }
        const messageTimestamp = timestamp || serverTimestamp || 0;
        void (0, attachmentsUtil_1.saveAttachmentToDisk)({
            attachment: attachments[targetAttachmentIndex],
            messageTimestamp,
            messageSender: sender,
            conversationId: convoId,
        });
    }, [convoId, sender, timestamp, serverTimestamp, convoId, attachments]);
    const copyText = (0, react_1.useCallback)(() => {
        const copyString = text || acceptUrl || txnId;
        interactions_1.MessageInteraction.copyBodyToClipboard(copyString);
    }, [text, acceptUrl, txnId]);
    const onRetry = (0, react_1.useCallback)(async () => {
        const found = await (0, data_1.getMessageById)(messageId);
        if (found) {
            await found.retrySend();
        }
    }, [messageId]);
    const onBan = (0, react_1.useCallback)(() => {
        interactions_1.MessageInteraction.banUser(sender, convoId);
    }, [sender, convoId]);
    const onUnban = (0, react_1.useCallback)(() => {
        interactions_1.MessageInteraction.unbanUser(sender, convoId);
    }, [sender, convoId]);
    const onSelect = (0, react_1.useCallback)(() => {
        dispatch((0, conversations_1.toggleSelectedMessageId)(messageId));
    }, [messageId]);
    const onDelete = (0, react_1.useCallback)(() => {
        void (0, unsendingInteractions_1.deleteMessagesById)([messageId], convoId);
    }, [convoId, messageId]);
    const onDeleteForEveryone = (0, react_1.useCallback)(() => {
        void (0, unsendingInteractions_1.deleteMessagesByIdForEveryone)([messageId], convoId);
    }, [convoId, messageId]);
    const copyTitle = text ? window.i18n('copyMessage') : acceptUrl ? window.i18n('copyAcceptUrl') : txnId ? window.i18n('copyTxnId') : null;
    return (react_1.default.createElement("div", { ref: contextMenuRef },
        ' ',
        react_1.default.createElement(react_contexify_1.Menu, { id: contextMenuId, onShown: onContextMenuShown, onHidden: onContextMenuHidden, animation: react_contexify_1.animation.fade },
            attachments?.length ? (react_1.default.createElement(react_contexify_1.Item, { onClick: saveAttachment },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'downloadAttachment', iconSize: 18 }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } }, window.i18n('downloadAttachment')))) : null,
            copyTitle && !isDeleted && (react_1.default.createElement(react_contexify_1.Item, { onClick: () => copyText() },
                react_1.default.createElement(CopyIcon_1.default, { color: 'var(--color-text)', iconSize: 18 }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } }, copyTitle))),
            (isSent || !isOutgoing) && !isDeleted && (react_1.default.createElement(react_contexify_1.Item, { onClick: onReply },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'reply', iconSize: 18 }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } }, window.i18n('replyToMessage')))),
            (!isPublic && !isPrivate) && (react_1.default.createElement(react_contexify_1.Item, { onClick: onShowDetail },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'infoCircle', iconSize: 18 }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } },
                    window.i18n('moreInformation'),
                    " "))),
            showRetry ? (react_1.default.createElement(react_contexify_1.Item, { onClick: onRetry },
                ' ',
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'resend', iconSize: 18 }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } },
                    window.i18n('resend'),
                    " "))) : null,
            isDeletable ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(react_contexify_1.Item, { onClick: onSelect },
                    ' ',
                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'tickBoxCurve', iconSize: 18 }),
                    react_1.default.createElement("span", { style: { marginLeft: '10px' } }, selectMessageText)))) : null,
            isDeletable && !isPublic ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(react_contexify_1.Item, { onClick: onDelete },
                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'delete', iconSize: 18, iconColor: "#FF3E3E" }),
                    react_1.default.createElement("span", { style: { marginLeft: '10px', color: '#FF3E3E' } }, deleteMessageJustForMeText)))) : null,
            isDeletableForEveryone ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(react_contexify_1.Item, { onClick: onDeleteForEveryone },
                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'twoMember', iconSize: 18, iconColor: "#FF3E3E" }),
                    react_1.default.createElement("span", { style: { marginLeft: '10px', color: '#FF3E3E' } }, unsendMessageText)))) : null,
            weAreAdmin && isPublic ? (react_1.default.createElement(react_contexify_1.Item, { onClick: onBan },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'banIcon', iconSize: 18, iconColor: "#FF3E3E", fillRule: "evenodd", clipRule: "evenodd" }),
                react_1.default.createElement("span", { style: { marginLeft: '10px', color: '#FF3E3E' } }, window.i18n('banUser')))) : null,
            weAreAdmin && isOpenGroupV2 ? (react_1.default.createElement(react_contexify_1.Item, { onClick: onUnban },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'unBanIcon', iconSize: 18 }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } }, window.i18n('unbanUser')))) : null,
            weAreAdmin && isPublic && !isSenderAdmin ? (react_1.default.createElement(react_contexify_1.Item, { onClick: addModerator },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'addModerator', iconSize: 18, iconColor: "#FF3E3E", fillRule: "evenodd", clipRule: "evenodd" }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } }, window.i18n('addAsModerator')))) : null,
            weAreAdmin && isPublic && isSenderAdmin ? (react_1.default.createElement(react_contexify_1.Item, { onClick: removeModerator },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'removeFromModerators', iconSize: 18, iconColor: "#FF3E3E", fillRule: "evenodd", clipRule: "evenodd" }),
                react_1.default.createElement("span", { style: { marginLeft: '10px' } }, window.i18n('removeFromModerators')))) : null)));
};
exports.MessageContextMenu = MessageContextMenu;
