"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageStatus = void 0;
const react_1 = __importDefault(require("react"));
const OutgoingMessageStatus_1 = require("./OutgoingMessageStatus");
const MessageStatus = (props) => {
    const { isCorrectSide, dataTestId, status } = props;
    const isIncoming = !isCorrectSide;
    const margin = isIncoming ? { marginLeft: '10px' } : { marginRight: '10px' };
    const showStatus = !isIncoming && Boolean(status);
    if (!showStatus) {
        return null;
    }
    return (react_1.default.createElement("span", { style: margin },
        react_1.default.createElement(OutgoingMessageStatus_1.OutgoingMessageStatus, { dataTestId: dataTestId, status: status })));
};
exports.MessageStatus = MessageStatus;
