"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataExtractionNotification = void 0;
const react_1 = __importDefault(require("react"));
const protobuf_1 = require("../../../../protobuf");
const Flex_1 = require("../../../basic/Flex");
const Text_1 = require("../../../basic/Text");
const icon_1 = require("../../../icon");
const ReadableMessage_1 = require("./ReadableMessage");
const DataExtractionNotification = (props) => {
    const { name, type, source, messageId, isUnread, receivedAt } = props;
    let contentText;
    const isSavedFile = type === protobuf_1.SignalService.DataExtractionNotification.Type.MEDIA_SAVED;
    if (isSavedFile) {
        contentText = window.i18n('savedTheFile', [name || source]);
    }
    else {
        contentText = window.i18n('tookAScreenshot', [name || source]);
    }
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center", justifyContent: "center", margin: 'var(--margins-sm)', id: `msg-${messageId}` },
            isSavedFile && react_1.default.createElement(icon_1.BchatIcon, { iconType: "upload", iconSize: "small", iconColor: 'var(--color-text-subtle)' }),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement(Text_1.Text, { text: contentText, subtle: true, ellipsisOverflow: true }))));
};
exports.DataExtractionNotification = DataExtractionNotification;
