"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericReadableMessage = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const react_contexify_1 = require("react-contexify");
const react_redux_1 = require("react-redux");
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
const data_1 = require("../../../../data/data");
const conversations_1 = require("../../../../bchat/conversations");
const conversations_2 = require("../../../../state/ducks/conversations");
const conversations_3 = require("../../../../state/selectors/conversations");
const timer_1 = require("../../../../util/timer");
const MessageAvatar_1 = require("../message-content/MessageAvatar");
const MessageContentWithStatus_1 = require("../message-content/MessageContentWithStatus");
const ReadableMessage_1 = require("./ReadableMessage");
const BchatIcon_1 = require("../../../icon/BchatIcon");
const theme_1 = require("../../../../state/selectors/theme");
const styled_components_1 = __importStar(require("styled-components"));
const GroupInvitation_1 = require("./GroupInvitation");
const PaymentMessage_1 = require("./PaymentMessage");
const SharedContactCardMessage_1 = require("./SharedContactCardMessage");
const EXPIRATION_CHECK_MINIMUM = 2000;
function useIsExpired(props) {
    const { convoId, messageId, expirationLength, expirationTimestamp, isExpired: isExpiredProps, } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const [isExpired] = (0, react_1.useState)(isExpiredProps);
    const checkExpired = (0, react_1.useCallback)(async () => {
        const now = Date.now();
        if (!expirationTimestamp || !expirationLength) {
            return;
        }
        if (isExpired || now >= expirationTimestamp) {
            await (0, data_1.removeMessage)(messageId);
            if (convoId) {
                dispatch((0, conversations_2.messageExpired)({
                    conversationKey: convoId,
                    messageId,
                }));
                const convo = (0, conversations_1.getConversationController)().get(convoId);
                convo?.updateLastMessage();
            }
        }
    }, [expirationTimestamp, expirationLength, isExpired, messageId, convoId]);
    let checkFrequency = null;
    if (expirationLength) {
        const increment = (0, timer_1.getIncrement)(expirationLength || EXPIRATION_CHECK_MINIMUM);
        checkFrequency = Math.max(EXPIRATION_CHECK_MINIMUM, increment);
    }
    (0, react_1.useEffect)(() => {
        void checkExpired();
    }, []);
    (0, useInterval_1.default)(checkExpired, checkFrequency);
    return { isExpired };
}
const highlightedMessageAnimation = (0, styled_components_1.keyframes) `
  1% {
      background-color: #00f782;
  }
`;
const StyledReadableMessage = (0, styled_components_1.default)(ReadableMessage_1.ReadableMessage) `
  display: flex;
  align-items: center;
  width: 100%;
  letter-spacing: 0.03em;
  margin-top: 5px;
  &.message-highlighted {
    animation: ${highlightedMessageAnimation} 1s ease-in-out;
  }
  ${props => props.isRightClicked &&
    `
    background-color:var(--color-chat-multi-select-bg);
  `}
  ${props => props.selected &&
    `
    &.message-selected {
      .module-message {
        &__container {
          box-shadow: var(--color-bchat-shadow);
        }
      }
    }
    `}
`;
const GenericReadableMessage = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const msgProps = (0, react_redux_1.useSelector)(state => (0, conversations_3.getGenericReadableMessageSelectorProps)(state, props.messageId));
    const isSelectionMode = (0, react_redux_1.useSelector)(conversations_3.isMessageSelectionMode);
    const expiringProps = {
        convoId: msgProps?.convoId,
        expirationLength: msgProps?.expirationLength,
        messageId: props.messageId,
        expirationTimestamp: msgProps?.expirationTimestamp,
        isExpired: msgProps?.isExpired,
    };
    const { isExpired } = useIsExpired(expiringProps);
    const isMessageSelected = (0, react_redux_1.useSelector)(state => (0, conversations_3.getIsMessageSelected)(state, props.messageId));
    const multiSelectMode = (0, react_redux_1.useSelector)(conversations_3.isMessageSelectionMode);
    const [isRightClicked, setIsRightClicked] = (0, react_1.useState)(false);
    const [enableReactions, setEnableReactions] = (0, react_1.useState)(true);
    const [recentEmojiBtnVisible, setRecentEmojiBtnVisible] = (0, react_1.useState)(false);
    const onMessageLoseFocus = (0, react_1.useCallback)(() => {
        if (isRightClicked) {
            setIsRightClicked(false);
        }
    }, [isRightClicked]);
    const handleContextMenu = (0, react_1.useCallback)((e) => {
        const enableContextMenu = !multiSelectMode && !msgProps?.isKickedFromGroup && !isDetailView;
        if (enableContextMenu) {
            react_contexify_1.contextMenu.hideAll();
            react_contexify_1.contextMenu.show({
                id: ctxMenuID,
                event: e,
            });
        }
        setIsRightClicked(enableContextMenu);
    }, [props.ctxMenuID, multiSelectMode, msgProps?.isKickedFromGroup]);
    const { ctxMenuID, messageId, isDetailView, serverName, acceptUrl, url, amount, txnId, address, name, } = props;
    if (!msgProps) {
        return null;
    }
    const { convoId, direction, conversationType, receivedAt, isUnread, expirationLength, expirationTimestamp, } = msgProps;
    (0, react_1.useEffect)(() => {
        const conversationModel = (0, conversations_1.getConversationController)().get(convoId);
        if (conversationModel) {
            setEnableReactions(conversationModel.hasReactions());
        }
    }, [convoId]);
    (0, react_1.useEffect)(() => {
        document.addEventListener('click', onMessageLoseFocus);
        return () => {
            document.removeEventListener('click', onMessageLoseFocus);
        };
    }, [onMessageLoseFocus]);
    if (isExpired) {
        return null;
    }
    const selected = isMessageSelected || false;
    const isGroup = conversationType === 'group';
    const isIncoming = direction === 'incoming';
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const iconColor = darkMode ? '#F0F0F0' : selected ? '#3E4A53' : '#ACACAC';
    const onSelect = (0, react_1.useCallback)(messageId => {
        dispatch((0, conversations_2.toggleSelectedMessageId)(messageId));
    }, [messageId]);
    const cardDesignTag = (() => {
        if (serverName) {
            return (react_1.default.createElement(GroupInvitation_1.GroupInvitation, { serverName: serverName, url: url || '', direction: "incoming", acceptUrl: acceptUrl || '', messageId: messageId, isUnread: props.isUnread ?? false, onRecentEmojiBtnVisible: () => setRecentEmojiBtnVisible(true) }));
        }
        if (txnId && amount) {
            return (react_1.default.createElement(PaymentMessage_1.PaymentMessage, { amount: amount, txnId: txnId, messageId: messageId, direction: direction, acceptUrl: acceptUrl, isUnread: props.isUnread ?? false, onRecentEmojiBtnVisible: () => setRecentEmojiBtnVisible(true) }));
        }
        if (address && name) {
            return (react_1.default.createElement(SharedContactCardMessage_1.SharedContactCardMessage, { address: address, name: name, messageId: messageId, isUnread: props.isUnread ?? false, isDetailView: isDetailView, onRecentEmojiBtnVisible: () => setRecentEmojiBtnVisible(true) }));
        }
        return null;
    })();
    return (react_1.default.createElement(StyledReadableMessage, { messageId: messageId, className: (0, classnames_1.default)('bchat-message-wrapper', selected && 'message-selected', isGroup && 'public-chat-message-wrapper', isIncoming ? 'bchat-message-wrapper-incoming' : 'bchat-message-wrapper-outgoing'), onContextMenu: handleContextMenu, receivedAt: receivedAt, isUnread: !!isUnread, key: `readable-message-${messageId}`, selected: selected, isRightClicked: isRightClicked },
        react_1.default.createElement("div", { className: "message-box", style: { cursor: isSelectionMode ? 'pointer' : 'default' }, onClick: () => isSelectionMode && onSelect(messageId), onMouseLeave: () => {
                setRecentEmojiBtnVisible(false);
            }, onMouseOver: () => setRecentEmojiBtnVisible(true) },
            react_1.default.createElement("div", { style: { margin: 'auto' } }, isSelectionMode && isIncoming && (react_1.default.createElement("div", { style: { marginRight: '15px', cursor: 'pointer' } },
                react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: !selected ? 'checkBox' : 'checkBoxTick', iconColor: iconColor, clipRule: "evenodd", fillRule: "evenodd", iconSize: 23 })))),
            !isDetailView && react_1.default.createElement(MessageAvatar_1.MessageAvatar, { messageId: messageId }),
            react_1.default.createElement(MessageContentWithStatus_1.MessageContentWithStatuses, { ctxMenuID: ctxMenuID, messageId: messageId, isDetailView: isDetailView, dataTestId: `message-content-${messageId}`, expirationLength: expirationLength, expirationTimestamp: expirationTimestamp, enableReactions: enableReactions, isRightClicked: isRightClicked, onMessageLoseFocus: onMessageLoseFocus, onHandleContextMenu: handleContextMenu, acceptUrl: acceptUrl, txnId: txnId, cardDesignTag: cardDesignTag, recentEmojiBtnVisible: recentEmojiBtnVisible, setRecentEmojiBtnVisible: e => setRecentEmojiBtnVisible(e) }),
            react_1.default.createElement("div", { style: { margin: 'auto' } }, !isIncoming && isSelectionMode && (react_1.default.createElement("div", { style: { marginLeft: '15px', cursor: 'pointer' } },
                react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: !selected ? 'checkBox' : 'checkBoxTick', iconColor: iconColor, clipRule: "evenodd", fillRule: "evenodd", iconSize: 23 })))))));
};
exports.GenericReadableMessage = GenericReadableMessage;
