"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupUpdateMessage = void 0;
const react_1 = __importDefault(require("react"));
const NotificationBubble_1 = require("./notification-bubble/NotificationBubble");
const ReadableMessage_1 = require("./ReadableMessage");
const message_1 = require("../../../../models/message");
const useParamSelector_1 = require("../../../../hooks/useParamSelector");
const ChangeItemJoined = (added) => {
    if (!added.length) {
        throw new Error('Group update add is missing contacts');
    }
    const names = (0, useParamSelector_1.useConversationsUsernameWithQuoteOrFullPubkey)(added);
    const joinKey = added.length > 1 ? 'multipleJoinedTheGroup' : 'joinedTheGroup';
    return added.length > 1 ? window.i18n(joinKey, [names.join(', ')]) : window.i18n(joinKey, [names.join('')]);
};
const ChangeItemKicked = (kicked) => {
    if (!kicked.length) {
        throw new Error('Group update kicked is missing contacts');
    }
    const names = (0, useParamSelector_1.useConversationsUsernameWithQuoteOrFullPubkey)(kicked);
    if ((0, message_1.arrayContainsUsOnly)(kicked)) {
        return window.i18n('youGotKickedFromGroup');
    }
    const kickedKey = kicked.length > 1 ? 'multipleKickedFromTheGroup' : 'kickedFromTheGroup';
    return window.i18n(kickedKey, [names.join(', ')]);
};
const ChangeItemLeft = (left) => {
    if (!left.length) {
        throw new Error('Group update remove is missing contacts');
    }
    const names = (0, useParamSelector_1.useConversationsUsernameWithQuoteOrFullPubkey)(left);
    if ((0, message_1.arrayContainsUsOnly)(left)) {
        return window.i18n('youLeftTheGroup');
    }
    const leftKey = left.length > 1 ? 'multipleLeftTheGroup' : 'leftTheGroup';
    return window.i18n(leftKey, [names.join(', ')]);
};
const ChangeItem = (change) => {
    switch (change.type) {
        case 'name':
            return window.i18n('titleIsNow', [change.newName || '']);
        case 'add':
            return ChangeItemJoined(change.added);
        case 'left':
            return ChangeItemLeft(change.left);
        case 'kicked':
            return ChangeItemKicked(change.kicked);
        case 'general':
            return window.i18n('updatedTheGroup');
        default:
            throw new Error('Missing case error');
    }
};
const GroupUpdateMessage = (props) => {
    const { change, messageId, receivedAt, isUnread } = props;
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement(NotificationBubble_1.NotificationBubble, { notificationText: ChangeItem(change) })));
};
exports.GroupUpdateMessage = GroupUpdateMessage;
