"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Message = exports.MINIMUM_LINK_PREVIEW_IMAGE_WIDTH = void 0;
const react_1 = __importDefault(require("react"));
const uuid_1 = __importDefault(require("uuid"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../../state/selectors/conversations");
const GenericReadableMessage_1 = require("./GenericReadableMessage");
exports.MINIMUM_LINK_PREVIEW_IMAGE_WIDTH = 200;
const Message = (props) => {
    const msgProps = (0, react_redux_1.useSelector)((state) => (0, conversations_1.getGenericReadableMessageSelectorProps)(state, props.messageId));
    const ctxMenuID = `ctx-menu-message-${(0, uuid_1.default)()}`;
    if (msgProps?.isDeleted && msgProps.direction === "outgoing") {
        return null;
    }
    return (react_1.default.createElement(GenericReadableMessage_1.GenericReadableMessage, { ctxMenuID: ctxMenuID, messageId: props.messageId, isDetailView: props.isDetailView, serverName: props.serverName, url: props.url, acceptUrl: props.acceptUrl, isUnread: props.isUnread, amount: props.amount, txnId: props.txnId, address: props.address, name: props.name }));
};
exports.Message = Message;
