"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageRequestResponse = void 0;
const react_1 = __importDefault(require("react"));
const useParamSelector_1 = require("../../../../hooks/useParamSelector");
const utils_1 = require("../../../../bchat/utils");
const Flex_1 = require("../../../basic/Flex");
const Text_1 = require("../../../basic/Text");
const ReadableMessage_1 = require("./ReadableMessage");
const MessageRequestResponse = (props) => {
    const { messageId, isUnread, receivedAt, conversationId } = props;
    const profileName = (0, useParamSelector_1.useConversationUsername)(conversationId);
    const isFromSync = props.source === utils_1.UserUtils.getOurPubKeyStrFromCache();
    let msgText = '';
    if (isFromSync) {
        msgText = profileName
            ? window.i18n('messageRequestAcceptedOurs', [profileName])
            : window.i18n('messageRequestAcceptedOursNoName');
    }
    else {
        msgText = window.i18n('messageRequestAccepted');
    }
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center", justifyContent: "center", margin: 'var(--margins-sm)', id: `msg-${messageId}` },
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement(Text_1.Text, { text: msgText, subtle: true, ellipsisOverflow: true }))));
};
exports.MessageRequestResponse = MessageRequestResponse;
