"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadableMessage = void 0;
const lodash_1 = __importStar(require("lodash"));
const react_1 = __importStar(require("react"));
const react_intersection_observer_1 = require("react-intersection-observer");
const react_redux_1 = require("react-redux");
const data_1 = require("../../../../data/data");
const conversations_1 = require("../../../../bchat/conversations");
const conversations_2 = require("../../../../state/ducks/conversations");
const conversations_3 = require("../../../../state/selectors/conversations");
const section_1 = require("../../../../state/selectors/section");
const BchatMessagesListContainer_1 = require("../../BchatMessagesListContainer");
const debouncedTriggerLoadMoreTop = lodash_1.default.debounce((selectedConversationKey, oldestMessageId) => {
    window.inboxStore?.dispatch((0, conversations_2.fetchTopMessagesForConversation)({
        conversationKey: selectedConversationKey,
        oldTopMessageId: oldestMessageId,
    }));
}, 100);
const debouncedTriggerLoadMoreBottom = lodash_1.default.debounce((selectedConversationKey, youngestMessageId) => {
    window.inboxStore?.dispatch((0, conversations_2.fetchBottomMessagesForConversation)({
        conversationKey: selectedConversationKey,
        oldBottomMessageId: youngestMessageId,
    }));
}, 100);
const ReadableMessage = (props) => {
    const { messageId, onContextMenu, className, receivedAt, isUnread } = props;
    const isAppFocused = (0, react_redux_1.useSelector)(section_1.getIsAppFocused);
    const dispatch = (0, react_redux_1.useDispatch)();
    const selectedConversationKey = (0, react_redux_1.useSelector)(conversations_3.getSelectedConversationKey);
    const loadedMessagesLength = (0, react_redux_1.useSelector)(conversations_3.getLoadedMessagesLength);
    const mostRecentMessageId = (0, react_redux_1.useSelector)(conversations_3.getMostRecentMessageId);
    const oldestMessageId = (0, react_redux_1.useSelector)(conversations_3.getOldestMessageId);
    const youngestMessageId = (0, react_redux_1.useSelector)(conversations_3.getYoungestMessageId);
    const fetchingMoreInProgress = (0, react_redux_1.useSelector)(conversations_3.areMoreMessagesBeingFetched);
    const conversationHasUnread = (0, react_redux_1.useSelector)(conversations_3.getConversationHasUnread);
    const scrollButtonVisible = (0, react_redux_1.useSelector)(conversations_3.getShowScrollButton);
    const shouldMarkReadWhenVisible = isUnread;
    const [didScroll, setDidScroll] = (0, react_1.useState)(false);
    const quotedMessageToAnimate = (0, react_redux_1.useSelector)(conversations_3.getQuotedMessageToAnimate);
    const scrollToLoadedMessage = (0, react_1.useContext)(BchatMessagesListContainer_1.ScrollToLoadedMessageContext);
    (0, react_1.useLayoutEffect)(() => {
        if (props.messageId === youngestMessageId &&
            !quotedMessageToAnimate &&
            !scrollButtonVisible &&
            !didScroll &&
            !conversationHasUnread) {
            scrollToLoadedMessage(props.messageId, 'go-to-bottom');
            setDidScroll(true);
        }
        else if (quotedMessageToAnimate) {
            setDidScroll(true);
        }
    });
    const onVisible = (0, react_1.useCallback)(async (inView) => {
        if (mostRecentMessageId === messageId && selectedConversationKey) {
            if (inView === true && isAppFocused) {
                dispatch((0, conversations_2.showScrollToBottomButton)(false));
                (0, conversations_1.getConversationController)()
                    .get(selectedConversationKey)
                    ?.markRead(receivedAt || 0);
                dispatch((0, conversations_2.markConversationFullyRead)(selectedConversationKey));
            }
            else if (inView === false) {
                dispatch((0, conversations_2.showScrollToBottomButton)(true));
            }
        }
        if (inView === true &&
            isAppFocused &&
            oldestMessageId === messageId &&
            !fetchingMoreInProgress &&
            selectedConversationKey) {
            debouncedTriggerLoadMoreTop(selectedConversationKey, oldestMessageId);
        }
        if (inView === true &&
            isAppFocused &&
            youngestMessageId === messageId &&
            !fetchingMoreInProgress &&
            selectedConversationKey) {
            debouncedTriggerLoadMoreBottom(selectedConversationKey, youngestMessageId);
        }
        if ((inView === true ||
            (inView.type === 'focus' && inView.returnValue === true)) &&
            isAppFocused) {
            if (shouldMarkReadWhenVisible) {
                const found = await (0, data_1.getMessageById)(messageId);
                if (found && Boolean(found.get('unread'))) {
                    const foundReceivedAt = found.get('received_at');
                    await found.markRead(Date.now());
                    if (foundReceivedAt) {
                        void (0, conversations_1.getConversationController)()
                            .get(found.id)
                            ?.sendReadReceiptsIfNeeded([foundReceivedAt]);
                    }
                }
            }
        }
    }, [
        selectedConversationKey,
        mostRecentMessageId,
        oldestMessageId,
        fetchingMoreInProgress,
        isAppFocused,
        loadedMessagesLength,
        receivedAt,
        shouldMarkReadWhenVisible,
        messageId,
    ]);
    return (react_1.default.createElement(react_intersection_observer_1.InView, { id: `msg-${messageId}`, onContextMenu: onContextMenu, className: className, as: "div", threshold: 0.8, delay: isAppFocused ? 100 : 200, onChange: isAppFocused ? onVisible : lodash_1.noop, triggerOnce: false, trackVisibility: true, key: `inview-msg-${messageId}`, "data-testid": "readable-message" }, props.children));
};
exports.ReadableMessage = ReadableMessage;
