"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationBubble = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const icon_1 = require("../../../../icon");
const NotificationBubbleFlex = styled_components_1.default.div `
  display: flex;

  // color: var(--color-text);
  // width: 90%;
  // max-width: 584px;
  // margin: 10px auto;
  padding: 5px 20px;
  border-radius: 42px;
  word-break: break-word;
  text-align: center;
  align-items: center;
  justify-content: center;
  // height: 40px;
  // margin-top: -20px;
  border-radius: 40px;
  background-color: var(--message-bubbles-received-background-color);
  z-index:2;
  
`;
const NotificationBubbleText = styled_components_1.default.div `
  // color: var(--color-text);
  // margin-left: 45px;
  color: var(--color-chat-timestamp);
  font-size: 14px;
  font-weight: 400;
`;
const NotificationBubbleIconContainer = styled_components_1.default.div `
  width: 30px;
  height: 30px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-right: 5px;
`;
const FlexCenter = styled_components_1.default.div `
  display: flex;
  // flex-direction: column;

  justify-content: center;
  width: 90%;
  // height: 1px;
  min-height: 40px;
  margin: 0 auto;
  
`;
const HorizontalLine = styled_components_1.default.div `
position:absolute;
width:90%;
height:1px;
margin-top:25px;
background-color: var(--message-bubbles-received-background-color);


`;
const NotificationBubble = (props) => {
    const { notificationText, iconType, iconColor, bgColor, callNotification, displayText } = props;
    return (react_1.default.createElement(FlexCenter, null,
        callNotification && react_1.default.createElement(HorizontalLine, null),
        react_1.default.createElement(NotificationBubbleFlex, { style: { margin: '0.3rem 0rem' } },
            iconType && (react_1.default.createElement(NotificationBubbleIconContainer, { style: { backgroundColor: bgColor } },
                react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: iconType, iconColor: iconColor, iconPadding: "auto 10px" }))),
            callNotification ? (react_1.default.createElement(NotificationBubbleText, { style: { color: 'var(--color-text)' } },
                notificationText,
                react_1.default.createElement("span", { style: { color: 'var(--color-chat-timestamp)' } },
                    " ",
                    displayText))) : (react_1.default.createElement(NotificationBubbleText, null, notificationText)))));
};
exports.NotificationBubble = NotificationBubble;
