"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactionPopup = exports.StyledPopupContainerWrapper = exports.StyledPopupContainer = void 0;
const react_1 = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const data_1 = require("../../../../data/data");
const readableList_1 = require("../../../../util/readableList");
const PubKey_1 = require("../../../../bchat/types/PubKey");
const emoji_1 = require("../../../../util/emoji");
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../../state/selectors/conversations");
exports.StyledPopupContainer = styled_components_1.default.div `
  display: flex;
  align-items: center;
  width: 216px;
  max-height: 72px;

 
  color: var(--color-text);
  font-size: 12px;
  font-weight: 400;
  padding: 16px;
  border-radius: 12px;
  cursor:${props => (props.isPrivate ? 'unset' : 'pointer')} ;
  overflow-wrap: break-word;
  background-color:var(--color-wallet-inner-bg);

  &:after {
    content: '';
    position: absolute;
    top: 60px;
    left: ${props => (props.isIncoming ? 0 : '189px')};
    width: 27px;
    height: 27px;
     background-color:var(--color-wallet-inner-bg);
    transform: rotate(45deg);
    border-radius: 3px;
    transform: scaleY(1) rotate(0deg);
    // clip-path: polygon(100% 100%, 7.2px 100%, 100% 7.2px);
    // box-shadow: 0px 0px 9px rgba(0, 0, 0, 0.51); /* theme relative color */
    clip-path:${props => props.isIncoming ? 'polygon(71% 0, 0 100%, 1% 0)' : 'polygon(34% 0, 100% 100%, 100% 0)'}
`;
exports.StyledPopupContainerWrapper = styled_components_1.default.div `
  position: absolute;
  width: 216px;
  height: 89px;
  // background-color: red;
  left: ${props => (props.isIncoming ? '22px' : '-187px')};
  top: -86px;
`;
const StyledEmoji = styled_components_1.default.span `
  font-size: 28px;
  margin-right: 8px;
`;
const generateContacts = async (messageId, senders) => {
    let results = null;
    const message = await (0, data_1.getMessageById)(messageId);
    if (message) {
        let meIndex = -1;
        results = senders.map((sender, index) => {
            const contact = message.findAndFormatContact(sender);
            if (contact.isMe) {
                meIndex = index;
            }
            return contact?.profileName || contact?.name || PubKey_1.PubKey.shorten(sender);
        });
        if (meIndex >= 0) {
            results.splice(meIndex, 1);
            results = [window.i18n('you'), ...results];
        }
    }
    return results;
};
const renderContacts = (contacts) => {
    if (!contacts) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    if (contacts.includes('&') && contacts.includes('other')) {
        const [names, others] = contacts.split('&');
        return (react_1.default.createElement("span", null,
            names,
            " & ",
            react_1.default.createElement("span", { style: { color: 'var(--color-text)', fontSize: '12px' } }, others),
            ' ',
            window.i18n('reactionTooltip')));
    }
    return (react_1.default.createElement("span", { style: { color: 'var(--color-text)', fontSize: '12px' } },
        contacts,
        " ",
        window.i18n('reactionTooltip')));
};
const ReactionPopup = (props) => {
    const { messageId, emoji, senders, onClick } = props;
    const [contacts, setContacts] = (0, react_1.useState)('');
    const messageProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageTextProps)(state, props.messageId));
    const isIncoming = messageProps?.direction === 'incoming';
    const isPrivate = messageProps?.conversationType === 'private';
    (0, react_1.useEffect)(() => {
        let isCancelled = false;
        generateContacts(messageId, senders)
            .then(async (results) => {
            if (isCancelled) {
                return;
            }
            if (results && results.length > 0) {
                setContacts((0, readableList_1.readableList)(results));
            }
        })
            .catch(() => {
            if (isCancelled) {
                return;
            }
        });
        return () => {
            isCancelled = true;
        };
    }, [generateContacts]);
    return (react_1.default.createElement(exports.StyledPopupContainerWrapper, { className: "popup-container-wrapper", isIncoming: isIncoming },
        react_1.default.createElement(exports.StyledPopupContainer, { isIncoming: isIncoming, isPrivate: isPrivate, onClick: () => {
                onClick();
            } },
            react_1.default.createElement(StyledEmoji, { role: 'img', "aria-label": emoji_1.nativeEmojiData?.ariaLabels ? emoji_1.nativeEmojiData.ariaLabels[emoji] : undefined }, emoji),
            renderContacts(contacts))));
};
exports.ReactionPopup = ReactionPopup;
